<?php

namespace App\Imports;

use App\Models\UserLogin;
use App\Models\Consultant;
use Illuminate\Http\Request;
use Maatwebsite\Excel\Concerns\ToModel;

class ConsultantImport implements ToModel
{
    /**
    * @param array $row
    *
    * @return \Illuminate\Database\Eloquent\Model|null
    */
    public function model(array $row)
    {
        $ip = UserLogin::whereUser_id(auth()->user()->id)->latest()->first()->checkin_ip;
        if($row[1] != '' && $row[0] != '' && $row[2] != '' && $row[3] != '' && $row[4] != '') {
            return new Consultant([
                'name'=>$row[0],
                'email'=>$row[1],
                'mobile'=>$row[2],
                'status'=>'enquiry',
                'visa_status'=>$row[3],
                'origin_country_id'=>101,
                'current_country_id'=>231,
                'current_state_id'=>$row[4],
                'created_ip'=>$ip,
                'reference'=>'database',
                'created_by'=>auth()->user()->id,
            ]);
        }
    }
}
