<?php

namespace App\Http\ViewComposers;

use DB;
use Auth; 
use Illuminate\View\View;

class FavouriteMenu
{ 

    /**
     * Bind data to the view.
     *
     * @param  View  $view
     * @return void
     */
    public function compose(View $view)
    {
        if(Auth::check()) {
            $favouritess = DB::table('favourites')->where('user_id', auth()->user()->id)->select('title', 'slug', 'id')->get();
            $favourites = $favouritess->pluck('title', 'slug');            
            $favouriteLinks = $favouritess->pluck('slug', 'id')->toArray(); 
        } else {
            $favourites = [];
            $favouriteLinks = [];
        }

        $view->with(['favourites'=> $favourites, 'favouriteLinks'=>$favouriteLinks]);
    }
}
