<?php

namespace App\Http\ViewComposers;
 
use Auth;
use App\Models\Company;
use Illuminate\View\View;

class All
{
    /**
     * Bind data to the view.
     *
     * @param  View  $view
     * @return void
     */
    public function compose(View $view)
    {
        $companies = Company::pluck('name', 'id')->all(); 
        if(Auth::check()) {
            $cname = $companies[auth()->user()->company_id];
        } else {
            $cname = '';
        }
        $view->with([
            'date_format' => 'yyyy-mm-dd',
            'appuser' => auth()->user(),
            'my_company' => $cname
        ]);
    }
}
