<?php

namespace App\Http\ViewComposers;

use Illuminate\View\View;
use Request;
use Cache;

class AccountsRequesturl
{ 

    /**
     * Bind data to the view.
     *
     * @param  View  $view
     * @return void
     */
    public function compose(View $view)
    { 
        Cache::rememberForever('ac_dashboard_slug',function(){
             return ['/accountsdashboard'];
        });

        Cache::rememberForever('ac_banking_slug',function(){
            return   ['/banking/accounts','/banking/accounts/create','/banking/accounts/'.Request::segment(3).'/edit','/banking/accounts/'.Request::segment(3)];
        });

        Cache::rememberForever('ac_transfers_slug',function(){
            return ['/banking/transfers','/banking/transfers/create','/banking/transfers/'.Request::segment(3).'/edit'];
        }); 

        Cache::rememberForever('ac_deposite_slug',function(){
            return ['/banking/deposit','/banking/deposit/create','/banking/deposit/'.Request::segment(3).'/edit','/banking/deposit/'.Request::segment(3)];
        });  

        Cache::rememberForever('ac_cheques_slug',function(){
            return ['/expenses/cheques','/expenses/cheques/create','/expenses/cheques/'.Request::segment(3).'/edit','/expenses/cheques/'.Request::segment(3)];
        });   

        Cache::rememberForever('ac_journal_slug',function(){
            return  ['/banking/journal','/banking/journal/create','/banking/journal/'.Request::segment(3).'/edit','/banking/journal/'.Request::segment(3)];
        });  

        Cache::rememberForever('ac_invoices_slug',function(){
            return ['/incomes/invoices','/common/import/incomes/payments','/common/import/incomes/invoices','/incomes/invoices/create','/incomes/customers/receivepayment/'.Request::segment(4).'/'.Request::segment(5),'/incomes/invoices/'.Request::segment(3),'/incomes/invoices/'.Request::segment(3).'/edit'];
        }); 

       Cache::rememberForever('ac_creditmemo_slug',function(){
            return ['/incomes/creditmemo','/incomes/creditmemo/create','/incomes/creditmemo/'.Request::segment(3),'/incomes/creditmemo/'.Request::segment(3).'/edit'];
       });

        Cache::rememberForever('ac_customers_slug',function(){
            return ['/incomes/customers','/incomes/customers/create','/incomes/customers/'.Request::segment(3).'/edit','/incomes/customers/'.Request::segment(3),'/incomes/customers/collectioncenter','/common/import/incomes/customers'];
        }); 

        Cache::rememberForever('ac_items_slug',function(){
            return ['/items/items','/common/import/items/items','/items/items/'.Request::segment(3).'/edit','/items/items/'.Request::segment(3)];
        });

        Cache::rememberForever('ac_bills_slug',function(){
            return ['/expenses/bills','/expenses/bills/create','/expenses/bills/makepayment/'.Request::segment(4),'/expenses/bills/'.Request::segment(3),'/expenses/bills/'.Request::segment(3).'/edit'];
        }); 

        Cache::rememberForever('ac_debitmemo_slug',function(){
            return ['/expenses/debitmemo','/expenses/debitmemo/create'];
        }); 

        Cache::rememberForever('ac_vendors_slug',function(){
            return ['/expenses/vendors','/expenses/vendors/create','/expenses/vendors/'.Request::segment(3),'/expenses/vendors/'.Request::segment(3).'/edit','/common/import/expenses/vendors','/expenses/vendors/billcenter'];
        }); 

        Cache::rememberForever('ac_payments_slug',function(){
            return ['/expenses/payments','/expenses/payments/create','/expenses/payments/'.Request::segment(3).'/edit'];
        });

        Cache::rememberForever('ac_reports_slug',function(){
            return ['/reports/standard','/reports/management'];
        }); 
        Cache::rememberForever('ac_std_reports_slug',function(){
            return ['/reports/standard'];
        }); 
        Cache::rememberForever('ac_mng_reports_slug',function(){
            return ['/reports/management'];
        });

        Cache::rememberForever('ac_chartofaccounts_slug',function(){
            return ['/accounting/chartofaccounts','/accounting/chartofaccounts/create','/accounting/chartofaccounts/'.Request::segment(3).'/edit','/accounting/chartofaccounts/'.Request::segment(3),'/common/import/accounting/chartofaccounts'];
        }); 

        Cache::rememberForever('ac_reconcile_slug',function(){
            return ['/banking/reconcile','/banking/reconcile/create','/banking/reconcile/'.Request::segment(3).'/edit'];
        });

        Cache::rememberForever('ac_consultnatpayrates_slug',function(){
            return ['/consultnatpayrates','/consultnatpayrates/create'];
        }); 

        Cache::rememberForever('ac_enterpayrole_slug',function(){
            return ['/payrole/timesheet'];
        });

        Cache::rememberForever('ac_runpayroe_slug',function(){
            return ['/payrole/runpayrole/create'];
        }); 

        Cache::rememberForever('ac_payrole_slug',function(){
            return ['/payrole/payrole','/payrole/payrole/create','/payrole/payrole/'.Request::segment(3).'/edit'];
        }); 

        Cache::rememberForever('ac_setuppayrole_slug',function(){
            return ['/payrole/setuppayrole'];
        }); 

        Cache::rememberForever('ac_paystub_slug',function(){
            return ['/payrole/paystubs'];
        }); 

        Cache::rememberForever('ac_settings_slug', function () {
            return ['/settings/ac_settings'];
        });

        $view->with([ ]);
    }
}
