<?php

namespace App\Http\ViewComposers;
 
use App\Models\Accounts\Accounting\Accounttypes;
use App\Models\Accounts\Accounting\Chartofaccounts; 
use Illuminate\View\View;
use Cache;

class AccountChartData
{


    /**
     * Bind data to the view.
     *
     * @param  View  $view
     * @return void
     */
    public function compose(View $view)
    {
        $types = collect(Accounttypes::pluck('account_name','id'));

        $account_details = Chartofaccounts::join('ac_account_type','ac_chart_of_accounts.account_type_id','=','ac_account_type.id')->select('ac_chart_of_accounts.name as name','ac_account_type.account_name','ac_chart_of_accounts.id','ac_chart_of_accounts.chart_parent_id')->get()->toArray();
        
        $account_details_name = $this->buildChartAccount($account_details);

        Cache::rememberForever('account_details_option',function() use ($account_details_name){
                return $this->buildChartOptions($account_details_name);
        }); 
 
        $view->with(['account_details_name'=>$account_details_name,'types'=> $types]);
    }

    public function buildChartOptions($account_details_name , $prefix = '',$value = 0) {
        $name = trans('general.form.select.field', ['field' => trans_choice('accounting.account_name', 1)]);
        if($value != 1){
            $html  = "<option value='' class='special'>".$name ."</option>";
            $html .= "<option value='add_new' >Add New</option>";
        }else{
            $html = '';
        }
        
         foreach ($account_details_name as $k=> $account) {  
             $html .= "<option value=".$account['id']."  data-subtext=".$account['account_name'].">". 
                       $prefix . $account['name']; 
                    if (isset($account['children'])){
                    $html .=     $this->buildChartOptions($account['children'],$prefix . $account['name'] ." : ",1);
                    }
             $html .= '</option>';
         }
        return $html; 
    }
    
    public function buildChartAccount(array $elements, $parentId = NULL) 
    {
        $child = array();
    
        foreach ($elements as $element) {
            if ($element['chart_parent_id'] == $parentId) {

                $children = $this->buildChartAccount($elements, $element['id']);

                    if (!empty($children) > 0 ) {
                        $element['children'] = $children;
                    }

                $child[] = $element;
            }
        }

        return $child;
    }
}
