<?php

namespace App\Http\Requests\Income;

use Illuminate\Foundation\Http\FormRequest;

class InvoicePayment extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {        
        return [
            'customer_id' => 'required|integer',
            'account_id' => 'required|integer',
            'paid_at' => 'required',
            'amount' => 'required',
            'currency_code' => 'required|string',
            'payment_method' => 'required|string',
            'attachment' => 'mimes:jpeg,jpg,png,pdf',
        ];
    }

    public function messages()
    {
        return [
            'customer_id.required' => 'Customer is Not Found',
        ];
    }
}
