<?php

namespace App\Http\Controllers;

use App\Models\Vendor;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class VendorController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $list = Vendor::with(['vendor_company', 'country', 'state', 'city', 'creater'])->latest()->get();

        return view('vendors.index', compact('list'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $vendorCompanies = vendorCompanySelect();
        $countries = countrySelect();
        $states = stateSelect();
        $cities = citySelect();

        return view('vendors.create', compact('vendorCompanies', 'countries', 'states', 'cities'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        DB::beginTransaction();
        $vendor = new Vendor;
        $vendor->vendor_company_id = $request->vendor_company_id;
        $vendor->name = $request->name;
        $vendor->email = $request->email;
        $vendor->mobile = $request->mobile;
        $vendor->website = $request->website;
        $vendor->payrate = $request->payrate;
        $vendor->country_id = $request->country_id;
        $vendor->state_id = $request->state_id;
        $vendor->city_id = $request->city_id;
        $vendor->address = $request->address;
        $vendor->save();
        DB::commit();
        
        Alert('success', 'Vendor created.');
        return redirect(route('vendors.index'));
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Vendor  $vendor
     * @return \Illuminate\Http\Response
     */
    public function show(Vendor $vendor)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Vendor  $vendor
     * @return \Illuminate\Http\Response
     */
    public function edit(Vendor $vendor)
    {
        $vendorCompanies = vendorCompanySelect();
        $countries = countrySelect();
        $states = stateSelect($vendor->country_id);
        $cities = citySelect($vendor->state_id);

        return view('vendors.edit', compact('vendorCompanies', 'countries', 'states', 'cities', 'vendor'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Vendor  $vendor
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        DB::beginTransaction();
        $vendor = Vendor::find($id);
        $vendor->vendor_company_id = $request->vendor_company_id;
        $vendor->name = $request->name;
        $vendor->email = $request->email;
        $vendor->mobile = $request->mobile;
        $vendor->website = $request->website;
        $vendor->payrate = $request->payrate;
        $vendor->country_id = $request->country_id;
        $vendor->state_id = $request->state_id;
        $vendor->city_id = $request->city_id;
        $vendor->address = $request->address;
        $vendor->created_by = auth()->user()->id;
        $vendor->update();
        DB::commit();
        
        Alert('success', 'Vendor updated.');
        return redirect(route('vendors.index'));
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Vendor  $vendor
     * @return \Illuminate\Http\Response
     */
    public function destroy(Vendor $vendor)
    {
        //
    }
}
