<?php

namespace App\Http\Controllers;

use App\Models\VendorCompany;
use Illuminate\Http\Request;

class VendorCompanyController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $list = VendorCompany::with(['creater'])->whereCompany_id(auth()->user()->company_id)->latest()->get();

        return view('vendor-companies.index', compact('list'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('vendor-companies.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $vc = new VendorCompany;
        $vc->company_id = auth()->user()->company_id;
        $vc->name = $request->name;
        $vc->created_by = auth()->user()->id;
        $vc->save();

        Alert('success', 'Vendor company created.');
        return redirect(route('vendor_companies.index'));
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\VendorCompany  $vendorCompany
     * @return \Illuminate\Http\Response
     */
    public function show(VendorCompany $vendorCompany)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\VendorCompany  $vendorCompany
     * @return \Illuminate\Http\Response
     */
    public function edit(VendorCompany $vendorCompany)
    {
        return view('vendor-companies.edit', compact('vendorCompany'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\VendorCompany  $vendorCompany
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, VendorCompany $vendorCompany)
    {
        $vendorCompany->name = $request->name;
        $vendorCompany->save();

        Alert('success', 'Vendor company updated.');
        return redirect(route('vendor_companies.index'));
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\VendorCompany  $vendorCompany
     * @return \Illuminate\Http\Response
     */
    public function destroy(VendorCompany $vendorCompany)
    {
        //
    }
}
