<?php

namespace App\Http\Controllers;

use Image;
use App\Models\User;
use App\Models\CommonMail;
use App\Models\Consultant;
use App\Models\UserProfile;
use Illuminate\Http\Request;
use App\Events\UpdateOptLiveCards;
use Spatie\Permission\Models\Role;
use Illuminate\Support\Facades\Hash;
use RealRashid\SweetAlert\Facades\Alert;

class UserController extends Controller
{
    public function index(Request $request)
    {

        $list = User::with(['department'])->latest()->get();

        return view('users.index', compact('list'));
    }

    public function create()
    {
        $data['departments'] = departmentSelect();
        $data['countries'] = countrySelect();
        $data['states'] = stateSelect();
        $data['cities'] = citySelect();
        $data['companies'] = companySelect();
        $data['roles'] = roleSelect();
        $data['users'] = userSelect();
        
        return view('users.create', $data);
    }

    public function store(Request $request)
    {
        $request['username'] = $request->email;      

        \DB::beginTransaction();
        // Create User
            $user = new User;
            $user->company_id = $request->company_id;
            $user->name = $request->name;
            $user->email = $request->email;
            $user->mobile = $request->mobile;
            $user->department_id = $request->department_id;
            $user->country_id = $request->country_id;
            $user->state_id = $request->state_id;
            $user->city_id = $request->city_id;
            $user->parent_id = $request->parent_id;
            $user->password = Hash::make('12345678');
            $user->save();

        // Assign Role
        if($user) {
            $user->assignRole($request->role_id);
        } else {
            return back()->withErrors($validator)->withInput();
        }

        /* Upload Profile Picture */
        if($request->profile_pic != '') {
            $image = $request->file('profile_pic');
            $imagename = time().'.'.$image->getClientOriginalExtension();
            $destinationPath = public_path('profile_images');
            $img_upload = $image->move($destinationPath, $imagename);

            $path = public_path('profile_images/'.$imagename);
            Image::make($path)->resize(220, 220)->save($path);
            $user->profile_image = $imagename;
            $user->save();
        }
        /* Ends */
        
        /* Saving User Profile */
        $profile = new UserProfile;
        $profile->user_id = $user->id;
        $profile->company_id = $request->company_id;
        $profile->join_date = date('Y-m-d');
        $profile->name = $request->mark_name;
        $profile->email = $request->mark_email;
        $profile->mobile = $request->mark_mobile;
        $profile->country_id = $request->mark_country_id;
        $profile->state_id = $request->mark_state_id;
        $profile->city_id = $request->mark_city_id;
        $profile->address = '';
        $profile->save();

        // On Success Send Email to user
        $content = '<p> please login into our application with below credentials</p><br>';
        $content .= '<a href="{{ url("/login") }}">Login</a>';
        $content .= '<p>>Username:- '.$user->email.'</p><br>';
        $content .= '<p>>Password:- 12345678</p><br>';
        CommonMail::sendHtml(env('MAIL_FROM_ADDRESS'), $user->email, 'User Credentials', $content);

        \DB::commit();

        // If user department in OPT Recruitment
        if($request->department_id == 3) {
            // Updating to live data from broadcast
            broadcast(new UpdateOptLiveCards());
        }

        return redirect('/users/create')->with('success', 'User created successfully!.');
    }

    public function edit($id)
    {
        $data['user'] = User::with(['profile'])->find($id);
        $data['departments'] = departmentSelect();
        $data['countries'] = countrySelect();
        $data['states'] = stateSelect($data['user']->country_id);
        $data['cities'] = citySelect($data['user']->state_id);
        $data['companies'] = companySelect();
        $data['roles'] = roleSelect();
        $data['users'] = userSelect();

        $role = $data['user']->getRoleNames();
        $data['role_id'] = Role::whereName($role)->first()->id;
        
        return view('users.edit', $data);
    }

    public function update(Request $request, $id)
    {
        \DB::beginTransaction();
        // Create User
            $user = User::find($id);
            $user->company_id = $request->company_id;
            $user->name = $request->name;
            $user->mobile = $request->mobile;
            $user->department_id = $request->department_id;
            $user->country_id = $request->country_id;
            $user->state_id = $request->state_id;
            $user->city_id = $request->city_id;
            $user->parent_id = $request->parent_id;
            $user->update();

        // Assign Role
        if($user) {
            $user->roles()->detach();
            $user->assignRole($request->role_id);
        } else {
            \DB::rolback();
            return back()->withErrors($validator)->withInput();
        }

        /* Upload Profile Picture */
        if($request->profile_pic != '') {
            $image = $request->file('profile_pic');
            $imagename = time().'.'.$image->getClientOriginalExtension();
            $destinationPath = public_path('profile_images');
            $img_upload = $image->move($destinationPath, $imagename);

                /* Delete OLD One */
                if($img_upload){
                    $previous_image = DB::table('users')->select('profile_image')->where('id',Auth::user()->id)->first();
                    $previous_image_name = $previous_image->profile_image;
                    if($previous_image_name!='' && file_exists(public_path('profile_images/'.$previous_image_name))){
                        unlink(public_path('storage/profile_images/'.$previous_image_name));
                    }
                }

            $path = public_path('profile_images/'.$imagename);
            Image::make($path)->resize(220, 220)->save($path);
            $usr1 = User::whereId($id)->first();
            $usr1->profile_image = $imagename;
            $usr1->update();
        }
        /* Ends */
        
        /* Saving User Profile */
        $usr = UserProfile::whereUser_id($id)->first();
        if(isset($usr)) {
            $profile = UserProfile::whereUser_id($id)->first();
        } else {
            $profile = new UserProfile;
        }
        $profile->company_id = auth()->user()->company_id;
        $profile->user_id = $user->id;
        $profile->join_date = date('Y-m-d');
        $profile->name = $request->mark_name;
        $profile->email = $request->mark_email;
        $profile->mobile = $request->mark_mobile;
        $profile->country_id = $request->mark_country_id;
        $profile->state_id = $request->mark_state_id;
        $profile->city_id = $request->mark_city_id;
        $profile->address = '';
        $profile->save();

        \DB::commit();

        Alert::success('User updated', 'User updated successfully');
        return redirect('/users/'.$id.'/edit')->with('success', 'User updated successfully!.');
    }

    // Profile
    public function profile()
    {
        $myId = auth()->user()->id;
        $user = User::with(['country', 'state', 'city'])->find($myId);
        $list = Consultant::with(['technologies', 'country', 'state', 'city'])->whereCreated_by($myId)->whereStatus('in_job')->latest()->limit(5)->get();
        $statuses = config('custom.employee_statuses');
        $technologies = technologySelect();

        return view('users.profile', compact('user', 'list', 'technologies', 'statuses'));
    }
}
