<?php

namespace App\Http\Controllers;

use PDF;
use Carbon\Carbon;
use App\Models\User;
use App\Models\State;
use App\Models\Client;
use App\Models\Vendor;
use App\Models\UserLogin;
use App\Models\Consultant;
use Illuminate\Support\Str;
use Illuminate\Http\Request;
use App\Models\ConsultantCall;
use App\Models\ConsultantResume;
use App\Models\ConsultantComment;
use Illuminate\Support\Facades\DB;
use App\Models\ConsultantTechnology;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Storage;

class UsefulController extends Controller
{
    // App main search
    public function mainSearch(Request $request)
    {
        $myId = auth()->user()->id;

        $list = Consultant::latest();

        if(isOpt()) {
            $list = $list->whereCreated_by($myId);
        }

        if(isBenchsales()) {
            $list = $list->whereCreated_by($myId)->orWhere('tech_recruiter_id', $myId);
        }

        if($request->search_text != '') {
            $list = $list->where('name', 'LIKE', '%'.$request->search_text.'%')->orWhere('mobile', 'LIKE', '%'.$request->search_text.'%')->orWhere('email', 'LIKE', '%'.$request->search_text.'%');
        }

        $list = $list->get();

        $statuses = config('custom.employee_statuses');
        $technologies = technologySelect();

        return view('consultants.index', compact('list', 'statuses', 'technologies'));
    }

    // By changing country get states
    public function getStates(Request $request)
    {
        $country_id = $request->country_id;

        if(is_null($country_id)) {
            return [];
        } else {
            $states = stateSelect($country_id);
            $state_select = '';
            foreach($states as $k=>$state){
                $state_select .= '<option value="'.$k.'">'.$state.'</option>';
            }
            echo $state_select;
        }
    }

    // By changing state get cities
    public function getCities(Request $request)
    {
        $state_id = $request->state_id;

        if(is_null($state_id)) {
            return [];
        } else {
            $cities = citySelect($state_id);
            
            $city_select = '';
            foreach($cities as $k=>$city){
                $city_select .= '<option value="'.$k.'">'.$city.'</option>';
            }
            echo $city_select;
        }
    }

    /* Adding Education */
    public function addEducation(Request $request)
    {
        $ncc = $request->ncc;
        $type = $request->type;

        $countries = countrySelect();
        $universities = universitySelect();
        if($type == 1) {
            return view('consultants.forms.us-education', compact('ncc', 'countries', 'universities'));
        } else {
            return view('consultants.forms.ind-education', compact('ncc', 'universities'));
        }
    }

    /* Adding Certification */
    public function addCertification(Request $request)
    {
        $ncc = $request->ncc;

        return view('consultants.forms.certification', compact('ncc'));
    }

    /* Adding Resume Experience */
    public function addExperience(Request $request)
    {
        $ncc = $request->ncc;
        $type = $request->type;

        $countries = countrySelect();
        if($type == 1) {
            return view('consultants.forms.resume-experience', compact('ncc', 'countries'));
        } else {
            return view('consultants.forms.it-experience', compact('ncc', 'countries'));
        }
    }

    /* Adding Reference */
    public function addReference(Request $request)
    {
        $ncc = $request->ncc;

        $countries = countrySelect();
        return view('consultants.forms.reference', compact('ncc', 'countries'));
    }

    /* Adding Attachment */
    public function addAttachment(Request $request)
    {
        $ncc = $request->ncc;

        return view('consultants.forms.attachment', compact('ncc'));
    }

    /* Adding Contact */
    public function addContact(Request $request)
    {
        $ncc = $request->ncc;
        $type = $request->type;

        $countries = countrySelect();
        if($type == 1) {
            return view('consultants.forms.us-contact', compact('ncc'));
        } else {
            return view('consultants.forms.overseas-contact', compact('ncc', 'countries'));
        }
    }

    /* Consultant details by ID */
    public function consultantDetails($id)
    {
        return json_encode(Consultant::find($id));
    }

    /* Saving consultant comments */
    public function saveComments(Request $request)
    {
        if($request->comment != '') {
            $cmnt = new ConsultantComment;
            $cmnt->consultant_id = $request->consultant_id;
            $cmnt->comment = $request->comment;
            $cmnt->user_id = auth()->user()->id;
            $cmnt->save();
        }

        $cmnt_list = ConsultantComment::with(['user'])->where('consultant_id', $request->consultant_id)->where('comment','!=','NULL')->get();

        foreach ($cmnt_list as  $cmnt) {
            $uname = isset($cmnt->user->name)?ucwords($cmnt->user->name):'';
            echo '<p class="pull-left" style="width: 100%; background: #EDEDED; margin-bottom: 2%; border-radius: 3px; padding:1%; color: black !important;">'.ucwords($cmnt->comment).'
                        <strong class="pull-right"><span class="fa fa-clock-o"></span> '.date(env('APP_DATE'), strtotime($cmnt->created_at)).'</strong>:'.$uname.'</p>';
        }
    }

    /* Listing users login details */
    public function userLogins(Request $request)
    {
        $list = UserLogin::with(['user'])->orderBy('checkin_time', 'desc')->get();

    	return view('users.user_logins', compact('list'));
    }

    // By visa type consultant count
    public function visaConsultantCount(Request $request)
    {
        $status = $request->status;
        $dates = explode('-', $request->mdates);
        $rdates = [date('Y-m-d', strtotime($dates[0])), date('Y-m-d', strtotime($dates[1] . ' +1 day'))];
        
        if($status != 'all'){
            $count = Consultant::whereCreated_by(auth()->user()->id)->whereBetween('created_at', $rdates)->whereVisa_status($status)->count();
        } else {
            $count = Consultant::whereCreated_by(auth()->user()->id)->whereBetween('created_at', $rdates)->count();
        }
        $data = array('count'=>$count, 'percentage'=>0);

        return json_encode($data);
    }

    // Dashboard consultants graph
    public function consultantsGraph(Request $request)
    {
        $type = $_REQUEST['type'];
        $year = $_REQUEST['year'];

        $consultant_graph_count = [];
        $months = config('custom.months_names');

        foreach($months as $k=>$val){
            $count = Consultant::whereMonth('created_at', $k)->whereYear('created_at', $year)->whereStatus($type)->where('created_by', auth()->user()->id)->count();

            $consultant_graph_count[] = array('month'=>date('Y-'.$k),'count'=>$count);
        }

        $consultant_graph_count = json_encode($consultant_graph_count);

        echo $consultant_graph_count;
    }

    // Dashboard Vector Map Data
    public function vectorMap(Request $request)
    {
        $myid = auth()->user()->id;
        $uuids = userUserIds($myid);
        $type = $request->dataType;
        
        // return State::withCount([$type => function($query) use ($myid){
        //     $query->where('created_by', $myid);
        // }])->where('country_id',231)->whereNotNull('state_code')->get()->groupBy('state_code');
        
        if(isAdmin()) {
            return State::withCount([$type])->where('country_id', 231)->whereNotNull('state_code')->get()->groupBy('state_code');
        } else {
            return State::withCount([$type => function($query) use ($uuids){
                $query->whereIn('created_by', $uuids);
            }])->where('country_id', 231)->whereNotNull('state_code')->get()->groupBy('state_code');
        }    
    }

    public function consultantsByState(Request $request, $id)
    {
        $list = Consultant::with(['technologies'])->whereCreated_by(auth()->user()->id)->whereCurrent_state_id($id)->get();
        $statuses = config('custom.employee_statuses');
        $technologies = technologySelect();
        $title = ucwords(State::find($id)->name).' - Consultant list';

        return view('consultants.vector-map-list', compact('list', 'statuses', 'technologies', 'title'));
    }

    public function clientsByState(Request $request, $id)
    {
        $list = Client::with(['country', 'state', 'city', 'creater'])->whereCreated_by(auth()->user()->id)->whereState_id($id)->get();
        $title = ucwords(State::find($id)->name).' - Client list';

        return view('clients.index', compact('list', 'title'));
    }

    public function downloadFile(Request $request, $id)
    {
        if($id != null) {
            if(file_exists(public_path("/storage/company_agreements/{$id}"))) {
                return response()->download(public_path("/storage/company_agreements/{$id}"));
            } else {
                return back()->with('warning', 'File does not exist');
            }
        } else {
            return back()->with('warning', 'File Not Found');
        }
    }

    /* Resume Search */
    public function resumeSearch(Request $request)
    {
        $list = [];
        return view('consultants.resume-search', compact('list'));
    }

    /* Resume Search */
    public function searchResume(Request $request)
    {
        $skills = $request->key_skills;
        $list = ConsultantResume::with(['consultant'])->where('skills', 'LIKE', "%{$skills}%")->get();
        
        return view('consultants.resume-search', compact('list'));
    }

    // Download Resume
    public function downloadResume($id)
    {
        $resume = ConsultantResume::whereId($id)->first();
        view()->share('resume', $resume);

        $pdf = PDF::loadView('common.resume-pdf');
        return $pdf->download('resume.pdf');
    }

    /**
     * Favourite Menu
     * $slug is URL
     * $title is Title For slug
     * $type is pin or Unpin
     */
    public function favouriteMenu(Request $request)
    {
        $slug = $request->slug;
        $title = $request->title;
        $type = $request->type;
        $uid = auth()->user()->id;

        if($type == 'pin') {
            if(DB::table('favourites')->whereUser_id($uid)->whereSlug($slug)->count() == 0) {
               return DB::table('favourites')->insertGetId(['user_id'=>$uid, 'title'=>$title, 'slug'=>$slug]);
            } else {
                return 'no';
            }
        }
        
        if($type == 'unpin') {
            $fid = DB::table('favourites')->whereUser_id($uid)->where('slug', $slug)->first()->id;
            DB::table('favourites')->whereUser_id($uid)->where('slug', $slug)->delete();
            return $fid;
        }

    }

    /**
     * Changin Company
     */
    public function changeCompany($id)
    {
        $user = User::find(auth()->user()->id);
        $user->company_id = $id;
        $user->update();

        Session::put('company_id', $id);

        return back()->with('success', 'Company changed successfully');
    }

    // Technology consultants
    public function technologyConsultants(Request $request)
    {
        if(isAdmin()) {
            $cids = array_unique(ConsultantTechnology::whereTechnology_id($request->technology_id)->pluck('consultant_id')->all());
            return Consultant::whereIn('id', $cids)->pluck('name', 'id')->all();
        }

        // If Opt
        if(isOpt()) {
            $cids = array_unique(ConsultantTechnology::whereTechnology_id($request->technology_id)->pluck('consultant_id')->all());
            return Consultant::whereCreated_by(auth()->user()->id)->whereIn('id', $cids)->pluck('name', 'id')->all();
        }

        // If Benchsales
        if(isBenchsales()) {
            $cids = array_unique(ConsultantTechnology::whereTechnology_id($request->technology_id)->pluck('consultant_id')->all());
            return Consultant::whereCreated_by(auth()->user()->id)->orWhere('tech_recruiter_id', auth()->user()->id)->whereIn('id', $cids)->pluck('name', 'id')->all();
        }
    }

    // Vendor Company Vendors
    public function vendorCompanyVendors(Request $request)
    {
        $prevIds = explode(',', $request->vendorIds);

        if(isAdmin()) {
            if($prevIds != '' && !is_null($prevIds)) {
                return Vendor::whereVendor_company_id($request->vc_id)->whereNotIn('id', $prevIds)->pluck('name', 'id')->all();
            }else {
                return Vendor::whereVendor_company_id($request->vc_id)->pluck('name', 'id')->all();
            }
        } else {
            if($prevIds != '' && !is_null($prevIds)) {
                return Vendor::whereVendor_company_id($request->vc_id)->whereCreated_by(auth()->user()->id)->whereNotIn('id', $prevIds)->pluck('name', 'id')->all();
            }else {
                return Vendor::whereVendor_company_id($request->vc_id)->whereCreated_by(auth()->user()->id)->pluck('name', 'id')->all();
            }
        }
    }

    // Vendor Details
    public function vendorDetails(Request $request)
    {
        return Vendor::whereId($request->vid)->first();
    }

    // Add vendor div
    public function addVendor(Request $request)
    {
        $data['newId'] = $request->next_cnt;
        $data['vendor_companies'] = vendorCompanySelect();
        $data['vendors'] = [];
        $data['implementors'] = implementorSelect();
        $data['clients'] = clientSelect();
        $data['countries'] = countrySelect();
        $data['states'] = stateSelect();
        $data['cities'] = citySelect();
        $data['technologies'] = technologySelect();
        $data['interview_modes'] = config('custom.interview_modes');
        $data['employment_types'] = config('custom.employment_types');

        return view('vendor-submissions.add-vendor', $data);
    }

    public function updateCallStatus(Request $request)
    {
        DB::beginTransaction();
        $lead = ConsultantCall::find($request->lead_id);
        $led = $lead->replicate();
        $led->call_status = $request->status;
        $led->comments = $request->status;
        if($request->status == 'call_me_later') {
            $led->callback_date = $request->callback_date;
        } else {
            $led->callback_date = NULL;
        }
        $led->status = 1;
        $led->save();

        
        $leadUp =  ConsultantCall::find($request->lead_id);
        $leadUp->status = 0;
        $leadUp->update();
        DB::commit();

        return 1;
    }

    public function dashboardCallleads(Request $request)
    {
        $leads = ConsultantCall::with(['consultant'])->where('call_status', 'call_me_later')->where('call_by', auth()->user()->id)->wherestatus(1)->latest()->paginate(5);

        if(count($leads) == 0) {
            return 1;
        }

        return view('dashboards.listing.call-leads', compact('leads'));
    }

    public function dashboardConsultantsList(Request $request)
    {
        $uuids = userUserIds();
        $consultants = Consultant::with(['technologies'])->whereIn('created_by', $uuids)->latest()->paginate(5);
        
        if(count($consultants) == 0) {
            return 1;
        }

        $technologies = technologySelect();
        $visas = config('custom.visa_statuses');
        $statuses = config('custom.employee_statuses');

        // Displaying data
        $dd = '';
        foreach($consultants as $consultant) {
            $techs = '';
            foreach ($consultant->technologies as $value) {
                $techs = $techs.' '.$technologies[$value->technology_id];
            }

            $dd .= '<tr>';
                $dd .= '<td>'.\Date::parse($consultant->created_at)->format(env('APP_DATE')).'</td>';
                $dd .= '<td>';
                    $dd .= '<a href="consultants/'.$consultant->id.'" style="text-decoration: underline;">'.ucwords($consultant->name).'</a>';
                $dd .= '</td>';
                $dd .= '<td>'.$consultant->mobile.'</td>';
                $dd .= '<td>'.$consultant->email.'</td>';
                $dd .= '<td title="'.$techs.'">'.Str::limit($techs, 15).'</td>';
                $dd .= '<td>'.$visas[$consultant->visa_status].'</td>';
                $dd .= '<td>'.$statuses[$consultant->status].'</td>';
                $dd .= '<td>'.ucwords($consultant->creater->name).'</td>';
                $dd .= '<td>';
                    $dd .= '<a title="Edit" href="/consultants/'.$consultant->id.'/edit" class="btn btn-outline-info btn-circle-iconic btn34"> <i class="material-icons">create</i></a> <button title="Add Comment" class="btn btn-outline-secondary btn-circle-iconic btn34" type="button" onclick="get_mail('.$consultant->email.')"> <i class="material-icons"> mail </i></button> <button title="Add Comment" class="btn btn-outline-secondary btn-circle-iconic btn34" type="button" onclick="addComment('.$consultant->id.')"> <i class="material-icons"> comment </i></button>';
                $dd .= '</td>';
            $dd .= '</tr>';
        }

        // return $dd;

        return view('dashboards.listing.consultant-list', compact('consultants', 'technologies', 'visas', 'statuses'));
    }

    public function getTimezoneDates()
    {
        return '<div class="col-sm-1"></div> <div class="col-sm-2"> <div class="daily-weather text-center"> <h2 class="day" style="font-size: 14px">EST</h2> <h4>'.Carbon::now('America/New_York')->format('h:i A').'</h4> </div> </div> <div class="col-sm-2"> <div class="daily-weather text-center"> <h2 class="day" style="font-size: 14px">CST</h2> <h4>'.Carbon::now('America/Chicago')->format('h:i A').'</h4> </div> </div> <div class="col-sm-2"> <div class="daily-weather text-center"> <h2 class="day" style="font-size: 14px">MST</h2> <h4>'.Carbon::now('MST')->addHour()->format('h:i A').'</h4> </div> </div> <div class="col-sm-2"> <div class="daily-weather text-center"> <h2 class="day" style="font-size: 14px">PST</h2> <h4>'.Carbon::now('PST')->addHour()->format('h:i A').'</h4> </div> </div> <div class="col-sm-2"> <div class="daily-weather text-center"> <h2 class="day" style="font-size: 14px">IST 12</h2> <h4>'.Carbon::now('Asia/Kolkata')->format('h:i A').'</h4> </div> </div> <div class="col-sm-1"></div> <div class="clearfix"></div>';
    }
}
