<?php

namespace App\Http\Controllers;

use App\Models\Consultant;
use Illuminate\Http\Request;
use App\Models\VendorSubmission;
use Illuminate\Support\Facades\Auth;

class SubmissionController extends Controller
{
    public function myConsultantSubmissions()
    {
        $myId = Auth::id();
        $cids = Consultant::whereCreated_by($myId)->where('status', '!=', 'dropped')->pluck('id')->all();
        
        $list = VendorSubmission::with(['consultant', 'job', 'client', 'creater'])->whereIn('consultant_id', $cids)->latest()->get();

        $statuses = config('custom.employee_statuses');
        $technologies = technologySelect();
        $vendor_statuses = config('custom.vendor_statuses');
        return view('consultants.my-consultant-submissions', compact('list', 'statuses', 'technologies', 'vendor_statuses'));
    }
}
