<?php

namespace App\Http\Controllers\Payrates;

use App\Models\Consultant;
use Illuminate\Http\Request;
use App\Models\VendorCompany;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use App\Models\Payrates\ConsultantPayrate;

class ConsultantPayrateController extends Controller
{
    public function index()
    {
        $list = ConsultantPayrate::with(['consultant'])->paginate(25);

        return view('payrates.consultants-payrates', compact('list'));
    }

    public function create() 
    {
        $consultants = Consultant::whereStatus('in_job')->pluck('name', 'id')->all();
        $vendorCompanies = VendorCompany::pluck('name', 'id')->all();

        return view('payrates.create-consultants-payrates', compact('consultants', 'vendorCompanies'));
    }

    public function store(Request $request) 
    {
        // dd($request->all());
        if(count($request->vendor_id) > 0) {
            foreach ($request->vendor_id as $key => $value) {
                $payrate = new ConsultantPayrate;
                $payrate->vendor_id = $value;
                $payrate->vendor_payrate_reg = $request->vendor_payrate_reg[$key];
                $payrate->vendor_payrate_ot = $request->vendor_payrate_ot[$key];
                $payrate->employee_id = $request->employee_id;
                $payrate->pay_type = $request->con_pay_type;
                $payrate->rate_type = $request->rate_type[$key];
                $payrate->from = $request->from[$key];
                $payrate->to = $request->to[$key];
                $payrate->from_date = date('Y-m-d', strtotime($request->from_date[$key]));
                $payrate->to_date = date('Y-m-d', strtotime($request->to_date[$key]));
                if($request->rate_type[$key] == 'fixed') {
                    $payrate->reg_rate = $request->reg_rate[$key];
                    $payrate->ot_rate = $request->ot_rate[$key];
                } else {
                    // Reg
                    $payrate->consultant_percentage_reg = $request->consultant_percent_reg[$key];
                    $payrate->percent_reg = $request->consultant_payrate_reg[$key];
                    $payrate->company_percentage_reg = $request->company_percent_reg[$key];
                    $payrate->company_payrate_reg = $request->company_payrate_reg[$key];
                    // OT
                    $payrate->consultant_percentage_ot = $request->consultant_percent_ot[$key];
                    $payrate->percent_ot = $request->consultant_payrate_ot[$key];
                    $payrate->company_percentage_ot = $request->company_percent_ot[$key];
                    $payrate->company_payrate_ot = $request->company_payrate_ot[$key];                 
                }
                $payrate->status = 1;
                $payrate->save();
            }
        }

        return redirect('/consultnatpayrates')->with('success', 'Pay rate added successfully!.');
    }

    /**
     * Consultant Payrates List
     */
    public function payrateList(Request $request)
    {
        $id = $request->con_id;

        $list = ConsultantPayrate::where('employee_id', $id)->get();

        return view('payrates.payrates-list', compact('list'));
    }

    public function getVendorCompanies()
    {
        $vendors = DB::table('vendor_companies')->select('id','name as value')->get();
        echo json_encode($vendors);
    }
}
