<?php

namespace App\Http\Controllers;

use App\Models\User;
use App\Models\Meeting;
use App\Models\MeetingIssue;
use Illuminate\Http\Request;
use App\Mail\ScheduleMeeting;
use App\Classes\CommonSelects;
use App\Events\MeetingCreated;
use App\Models\MeetingRecursion;
use App\Models\MeetingParticipant;
use Illuminate\Support\Facades\Mail;

class MeetingController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        if(!isAdmin()) {
            $list = Meeting::with(['participants'])->whereOrganised_by(auth()->user()->id)->latest()->get();
        } else {
            $list = Meeting::with(['participants'])->latest()->get();
        }
        return view('meetings.index', compact('list'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $participants = userSelect();
        $venues = ['1'=>'Conference Room', '2'=>'Online'];
        $number = Meeting::count();
        if($number!=0) {
            $number = Meeting::latest()->first()->id;
            $number++;
        } else {
            $number = 1;
        }
        $consultants = consultantSelect();

        return view('meetings.create', compact('participants', 'venues', 'number', 'consultants'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        // dd($request->all());
        $number = Meeting::count();
        if($number!=0) {
            $number = Meeting::latest()->first()->id;
            $number++;
        } else {
            $number = 1;
        }
        \DB::beginTransaction();
        $meeting = new Meeting;
        $meeting->company_id = auth()->user()->company_id;
        $meeting->organised_by = auth()->user()->id;
        $meeting->venue = $request->venue;
        $meeting->number = $number;
        $meeting->subject = $request->subject;
        $meeting->date = $request->date;
        $meeting->time = $request->time1;
        $meeting->time1 = $request->time2;
        $meeting->time2 = $request->time3;
        $meeting->duration = $request->duration;
        $meeting->agenda = $request->agenda;
        $meeting->dpoints = $request->dpoints;
        $meeting->recursion_end = $request->rdate;
        if(isset($request->draft)) {
            $meeting->status = 1;
        } else if(isset($request->send_mail)) {
            $meeting->status = 2;
        }  else if(isset($request->completed)) {
            $meeting->status = 3;
        }
        $meeting->save();

        // Saving Participants
        if($request->pids != '') {
            $ids = ($request->pids!= '')?$request->pids:[];
            $ss = ($request->sts != '')?$request->sts:[];
            foreach ($ids as $key => $value) {
                $mu = new MeetingParticipant;
                $mu->company_id = auth()->user()->company_id;
                $mu->meeting_id = $meeting->id;
                $mu->user_id = $value;
                if(in_array($value, $ss)) {
                    $mu->status = 1;
                } else {
                    $mu->status = 0;
                }
                $mu->save();
                
                broadcast(new MeetingCreated($value))->toOthers();
            }
        }

        // Save Meeting Issue Statements
        if($request->rparticipants != '') {
            foreach ($request->rparticipants as $key => $value) {
                if($value != '') {
                    $iss = 'issue'.$value;
                    $sol = 'solution'.$value;
                    $sts = 'sts'.$value;
                    $consultant = 'consultant'.$value;

                    $issue = new MeetingIssue;
                    $issue->company_id = auth()->user()->company_id;
                    $issue->meeting_id = $meeting->id;
                    $issue->user_id = $value;
                    $issue->consultant = $request->$consultant;
                    $issue->issue = $request->$iss;
                    $issue->solution = $request->$sol;
                    $issue->status = $request->$sts;
                    $issue->save();
                }
            }
        }

        // Recursion meetings adding
        if($request->weeks != '') {
            foreach ($request->weeks as $key => $value) {
                $rec = new MeetingRecursion;
                $rec->company_id = auth()->user()->company_id;
                $rec->meeting_id = $meeting->id;
                $rec->week = $value;
                $rec->save();
            }
        }

        // Sending Mail
        if($meeting) {
            \DB::commit();
            if(isset($request->send_mail)) {
                $uemails = User::whereIn('id', $request->pids)->pluck('email')->all();

                // Sending Mails to participants
                $ssubject = 'Meeting scheduled for '.$meeting->date;
                $ccc = [auth()->user()->email, 'hr@r10networks.com'];
                $bbcc = ['swetha@r10networks.com'];
                $bbcc = [];
                $pids = [1, 2];
                foreach($pids as $pid) {
                    $user = User::find($pid);
                    Mail::to('brvk007@gmail.com')->send(new ScheduleMeeting($ssubject, $ccc, $bbcc, $user, $meeting));
                }
            }
        } else {
            \DB::rollback();
        }
        
        \Session::flash('success', 'Meeting scheduled successfully.');
        return redirect(route('meetings.index'));
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Meeting  $meeting
     * @return \Illuminate\Http\Response
     */
    public function show(Meeting $meeting)
    {
        $participants = CommonSelects::users();
        $mparticipants = MeetingParticipant::with(['user'])->whereMeeting_id($meeting->id)->get();
        $mpids = MeetingParticipant::with(['user'])->whereMeeting_id($meeting->id)->pluck('user_id')->all();
        $venues = ['1'=>'Conference Room', '2'=>'Online'];
        $issues = MeetingIssue::with(['user'])->whereMeeting_id($meeting->id)->get();

        $title = 'View Meeting';
        return view('meetings.show', compact('title', 'participants', 'meeting', 'mparticipants', 'mpids', 'venues', 'issues'));
    }    

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Meeting  $meeting
     * @return \Illuminate\Http\Response
     */
    public function edit(Meeting $meeting)
    {
        $participants = userSelect();
        $mparticipants = MeetingParticipant::with(['user'])->whereMeeting_id($meeting->id)->get();
        $mpids = MeetingParticipant::with(['user'])->whereMeeting_id($meeting->id)->pluck('user_id')->all();
        $venues = ['1'=>'Conference Room', '2'=>'Online'];
        $issues = MeetingIssue::whereMeeting_id($meeting->id)->get();
        $weeks = MeetingRecursion::whereMeeting_id($meeting->id)->pluck('week')->all();

        return view('meetings.edit', compact('participants', 'meeting', 'mparticipants', 'mpids', 'venues', 'issues', 'weeks'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Meeting  $meeting
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Meeting $meeting)
    {
        // dd($request->all());
        \DB::beginTransaction();
        $meeting->company_id = auth()->user()->company_id;
        $meeting->organised_by = auth()->user()->id;
        $meeting->venue = $request->venue;
        $meeting->number = $request->number;
        $meeting->subject = $request->subject;
        $meeting->date = $request->date;
        $meeting->time = $request->time1;
        $meeting->time1 = $request->time2;
        $meeting->time2 = $request->time3;
        $meeting->duration = $request->duration;
        $meeting->agenda = $request->agenda;
        $meeting->dpoints = $request->dpoints;
        $meeting->recursion_end = $request->rdate;
        if(isset($request->draft)) {
            $meeting->status = 1;
        } else if(isset($request->send_mail)) {
            $meeting->status = 2;
        }  else if(isset($request->completed)) {
            $meeting->status = 3;
        }
        $meeting->update();

        // Adding participants
        if($request->pids != '' && $request->sts != '') {
            $ids = ($request->pids!= '')?$request->pids:[];
            $ss = ($request->sts != '')?$request->sts:[];
            array_push($ids, ''.auth()->user()->id.'');
            array_push($ss, ''.auth()->user()->id.'');
            
            // Delete previous participants
            MeetingParticipant::where('meeting_id', $meeting->id)->delete();
            // Storing new participants
            foreach ($ids as $key => $value) {
                $mu = new MeetingParticipant;
                $mu->company_id = auth()->user()->company_id;
                $mu->meeting_id = $meeting->id;
                $mu->user_id = $value;
                if(in_array($value, $ss)) {
                    $mu->status = 1;
                } else {
                    $mu->status = 0;
                }
                $mu->save();
            }
        }

        // Save Meeting Issue Statements
        if($request->rparticipants != '') {
            // removing previous issues
            MeetingIssue::whereMeeting_id($meeting->id)->delete();

            foreach ($request->rparticipants as $key => $value) {
                $iss = 'issue'.$value;
                $sol = 'solution'.$value;
                $sts = 'sts'.$value;
                $consultant = 'consultant'.$value;

                $issue = new MeetingIssue;
                $issue->company_id = auth()->user()->company_id;
                $issue->meeting_id = $meeting->id;
                $issue->user_id = $value;
                $issue->consultant = $request->$consultant;
                $issue->issue = $request->$iss;
                $issue->solution = $request->$sol;
                $issue->status = $request->$sts;
                $issue->save();
            }
        }

        // Recursion meetings adding
        if($request->weeks != '') {
            // removing previous recursions
            MeetingRecursion::whereMeeting_id($meeting->id)->delete();
            
            foreach ($request->weeks as $key => $value) {
                $rec = new MeetingRecursion;
                $rec->company_id = auth()->user()->company_id;
                $rec->meeting_id = $meeting->id;
                $rec->week = $value;
                $rec->save();
            }
        }

        if($meeting) {
            \DB::commit();
        } else {
            \DB::rollback();
        }

        \Session::flash('success', 'Meeting updated successfully.');
        return redirect(route('meetings.index'));
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Meeting  $meeting
     * @return \Illuminate\Http\Response
     */
    public function destroy(Meeting $meeting)
    {
        //
    }

    /** Select Participants */
    public function participants(Request $request)
    {
        if($request->ids != '') {
            $uids = explode(',', $request->ids);

            $users = User::whereActive('1')->whereIn('id', $uids)->select('name', 'id')->get();

            return $users;
        }
    }

    /* Showing Scheduled meetings */
    public function scheduled()
    {        
        $list = Meeting::with(['participants'=>function($q) {
            if(!isAdmin()) {
                $q->whereUser_id(auth()->user()->id);
            }
        }])->whereNotIn('status', [3])->get();

        $title = 'Total Meetings';
        return view('meetings.schedules', compact('title', 'list'));
    }

    /* Meeting Analytics */
    public function analytics()
    {
        $list = MeetingIssue::with(['user', 'meeting'])->latest()->get();

        $title = 'Meeting Analytics';
        return view('meetings.analytics', compact('title', 'list'));
    }

    /* Copy same meeting */
    public function copy($id)
    {
        // Creating new meeting number
        $newId = Meeting::latest()->first()->id;
        // Saving Meeting
        $meets = Meeting::find($id);
        $meet = $meets->replicate();
        $meet->date = date('Y-m-d');
        $meet->number = $newId + 1;
        $meet->status = 1;
        $meet->save();
        // // Replicate meeting participants
        // if($meet) {
        //     $participants = MeetingParticipant::whereMeeting_id($id)->get();
        //     foreach ($participants as $value) {
        //         $part = new MeetingParticipant;
        //         $part->company_id = $value->company_id;
        //         $part->meeting_id = $meet->id;
        //         $part->user_id = $value->user_id;
        //         $part->status = $value->status;
        //         $part->save();
        //     }
        // }

        \Session::flash('success', 'Meeting copied successfully');
        return redirect(route('meetings.index'));
    } 
}
