<?php

namespace App\Http\Controllers;

use App\Models\Campaign;
use App\Models\CampaignList;
use Illuminate\Http\Request;
use App\Models\CampaignContact;
use App\Models\CampaignTemplate;

class MailCampainController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        if(isAdmin()) {
            $data['lists'] = Lists::count();
            $data['templates'] = Template::count();
            $data['campaigns'] = Campaign::count();
            $data['subscribers'] = Contact::whereStatus(1)->count();
            $data['users'] = User::count();

            return view('mail_campaign.home', $data);
        }else {
            $url = "https://mandrillapp.com/api/1.0/senders/info.json";

            $options = array(
                        CURLOPT_RETURNTRANSFER => true, // return web page
                        CURLOPT_HEADER         => false,// don't return headers
                        CURLOPT_FOLLOWLOCATION => false,// follow redirects
                        // CURLOPT_ENCODING       => "utf-8",  // handle all encodings
                        CURLOPT_AUTOREFERER    => true,  // set referer on redirect
                        CURLOPT_CONNECTTIMEOUT => 20, // timeout on connect
                        CURLOPT_TIMEOUT        => 20, // timeout on response
                        CURLOPT_POST            => 1, // i am sending post data
                        CURLOPT_POSTFIELDS     => json_encode(['key'=>env('MANDRILL_SECRET', 'NaZxQF7HNH-aRPpJzGxd6A'), 'address'=>auth()->user()->email]),    // this are my post vars
                        CURLOPT_SSL_VERIFYHOST => 0, // don't verify ssl
                        CURLOPT_SSL_VERIFYPEER => false,
                        CURLOPT_VERBOSE        => 1,
                        CURLOPT_HTTPHEADER     => array(
                            "Content-Type: application/json"
                        )
                    );

            $list = callCrl($url, $options);
            $data['sender'] = json_decode($list);

            $data['lists'] = CampaignList::whereUser_id(auth()->user()->id)->count();
            $data['templates'] = CampaignTemplate::whereUser_id(auth()->user()->id)->count();
            $data['campaigns'] = Campaign::whereUser_id(auth()->user()->id)->count();
            $data['subscribers'] = CampaignContact::whereUser_id(auth()->user()->id)->whereStatus(1)->count();
        
            return view('mail-campaign.index', $data);
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
