<?php

namespace App\Http\Controllers;

use App\Models\Consultant;
use Illuminate\Http\Request;
use App\Models\VendorSubmission;
use App\Events\UpdateOptLiveCards;
use App\Models\Accounts\Expense\Bill;
use App\Models\Accounts\Income\Invoice;

class LiveDataController extends Controller
{
    public function optlivecardsdata()
    {
        $consultants = Consultant::count();
        $opts = count(userSelect(3));
        $marketing = Consultant::whereIn('status', ['on_bench', 'open_bench'])->count();
        // $enquiry = Consultant::whereStatus('enquiry')->count();
        // $injob = Consultant::whereStatus('in_job')->count();
        $training = Consultant::whereStatus('in_training')->count();
        
        return response()->json(['opt'=>$opts, 'consultants'=>$consultants, 'training'=>$training, 'marketing'=>$marketing]);
    }

    public function optpolardata()
    {
        $consultants = Consultant::count();
        $enquiry = Consultant::whereStatus('enquiry')->count();
        $training = Consultant::whereStatus('in_training')->count();
        $marketing = Consultant::whereIn('status', ['on_bench', 'open_bench'])->count();
        $in_job = Consultant::whereStatus('in_job')->count();
        
        return response()->json([$consultants, $enquiry, $training, $marketing, $in_job]);
    }

    public function optbardata()
    {
        $months = config('custom.months_names');

        $enquiry = [];
        $training = [];
        $marketing = [];

        foreach($months as $k=>$val){
            $count = Consultant::whereMonth('created_at', $k)->whereYear('created_at', date('Y'))->whereStatus('enquiry')->count();
            array_push($enquiry, $count);

            $count = Consultant::whereMonth('created_at', $k)->whereYear('created_at', date('Y'))->whereStatus('in_training')->count();
            array_push($training, $count);

            $count = Consultant::whereMonth('created_at', $k)->whereYear('created_at', date('Y'))->whereIn('status', ['on_bench', 'open_bench'])->count();
            array_push($marketing, $count);
        }
        
        return response()->json([$enquiry, $training, $marketing]);
    }

    public function optlinedata()
    {
        $months = config('custom.months_names');

        $enquiry = [];
        $training = [];
        $marketing = [];

        foreach($months as $k=>$val){
            $count = Consultant::whereMonth('created_at', $k)->whereYear('created_at', date('Y'))->whereStatus('enquiry')->count();
            array_push($enquiry, $count);

            $count = Consultant::whereMonth('created_at', $k)->whereYear('created_at', date('Y'))->whereStatus('in_training')->count();
            array_push($training, $count);

            $count = Consultant::whereMonth('created_at', $k)->whereYear('created_at', date('Y'))->whereIn('status', ['on_bench', 'open_bench'])->count();
            array_push($marketing, $count);
        }
        
        return response()->json([$enquiry, $training, $marketing]);
    }

    // Benchsales live data
    public function benchlivecardsdata()
    {
        $bench = count(userSelect(4));
        $marketing = Consultant::whereIn('status', ['on_bench', 'open_bench'])->count();
        $injob = Consultant::whereStatus('in_job')->count();
        $submissions = VendorSubmission::whereActive(1)->count();
        
        return response()->json(['bench'=>$bench, 'marketing'=>$marketing, 'injob'=>$injob, 'submissions'=>$submissions]);
    }

    public function benchpolardata()
    {
        $submissions = VendorSubmission::whereActive(1)->count();
        $marketing = Consultant::whereIn('status', ['on_bench', 'open_bench'])->count();
        $injob = Consultant::whereStatus('in_job')->count();
        
        return response()->json([$submissions, $marketing, $injob]);
    }

    public function benchbardata()
    {
        $months = config('custom.months_names');

        $submissions = [];
        $marketing = [];
        $injob = [];

        foreach($months as $k=>$val){
            $scount = VendorSubmission::whereMonth('created_at', $k)->whereYear('created_at', date('Y'))->whereStatus('enquiry')->whereActive(1)->count();
            array_push($submissions, $scount);

            $mcount = Consultant::whereMonth('created_at', $k)->whereYear('created_at', date('Y'))->whereIn('status', ['on_bench', 'open_bench'])->count();
            array_push($marketing, $mcount);

            $icount = Consultant::whereMonth('created_at', $k)->whereYear('created_at', date('Y'))->whereStatus('in_job')->count();
            array_push($injob, $icount);
        }
        
        return response()->json([$submissions, $marketing, $injob]);
    }

    public function benchlinedata()
    {
        $months = config('custom.months_names');

        $submissions = [];
        $marketing = [];
        $injob = [];

        foreach($months as $k=>$val){
            $scount = VendorSubmission::whereMonth('created_at', $k)->whereYear('created_at', date('Y'))->whereStatus('enquiry')->whereActive(1)->count();
            array_push($submissions, $scount);

            $mcount = Consultant::whereMonth('created_at', $k)->whereYear('created_at', date('Y'))->whereIn('status', ['on_bench', 'open_bench'])->count();
            array_push($marketing, $mcount);

            $icount = Consultant::whereMonth('created_at', $k)->whereYear('created_at', date('Y'))->whereStatus('in_job')->count();
            array_push($injob, $icount);
        }
        
        return response()->json([$submissions, $marketing, $injob]);
    }

    public function accountslivecardsdata()
    {
        // Invoices
        $paid = Invoice::where('invoice_status_code', 'paid')->sum('amount'); 
        $invoices = ceil(($paid != '')?$paid:0);

        // Bills
        $billsAmt = Bill::where('bill_status_code', 'paid')->sum('amount');
        $bills = ceil(($billsAmt != '') ? $billsAmt : 0);

        // Profit
        $profitTtl = $paid - $billsAmt;
        $profit = ceil(($profitTtl != '') ? $profitTtl : 0);
        
        return response()->json(['invoices'=>$invoices, 'bills'=>$bills, 'profit'=>$profit]);
    }

    public function accountsbardata()
    {
        $months = config('custom.months_names');

        $income = [];
        $expense = [];

        foreach($months as $k=>$val){
            $count = Invoice::whereMonth('created_at', $k)->whereYear('created_at', date('Y'))->where('invoice_status_code', 'paid')->sum('amount');
            array_push($income, $count);

            $count = Bill::whereMonth('created_at', $k)->whereYear('created_at', date('Y'))->where('bill_status_code', 'paid')->sum('amount');
            array_push($expense, $count);
        }
        
        return response()->json([$income, $expense]);
    }

    public function accountspolardata()
    {        
        return response()->json([[120,222,300], [120,222,300]]);
    }
}
