<?php

namespace App\Http\Controllers;

use App\Models\Job;
use App\Models\JobVendor;
use App\Models\Consultant;
use Illuminate\Http\Request;
use App\Models\ConsultantJob;
use Illuminate\Support\Facades\DB;
use RealRashid\SweetAlert\Facades\Alert;

class JobController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $list = Job::with(['creater', 'country', 'state', 'city'])->latest()->get();

        return view('jobs.index', compact('list'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $countries = countrySelect();
        $states = stateSelect();
        $cities = citySelect();
        $technologies = technologySelect();
        $interview_modes = config('custom.interview_modes');
        $employment_types = config('custom.employment_types');
        $vendor_Companies = vendorCompanySelect();
        $vendors = vendorSelect();
        $clients = clientSelect();
        $implementors = implementorSelect();

    	return view('jobs.create', compact('countries', 'states', 'cities', 'technologies', 'interview_modes', 'employment_types', 'vendor_Companies', 'vendors', 'clients', 'implementors'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        DB::beginTransaction();
        $job = new Job;
        $job->title = $request->title;
        $job->min_experience = $request->min_experience;
        $job->max_experience = $request->max_experience;
        $job->interview_mode = $request->interview_mode;
        $job->employment_type = $request->employment_type;
        $job->description = $request->description;
        $job->internal_message = $request->internal_message;
        $job->interview_address = $request->interview_address;
        $job->interview_address = $request->interview_address;
        $job->status = $request->status;
        $job->min_payrate = $request->min_payrate;
        $job->max_payrate = $request->max_payrate;
        $job->country_id = $request->country_id;
        $job->state_id = $request->state_id;
        $job->city_id = $request->city_id;
        $job->client_id = $request->client_id;
        $job->implementor_id = $request->implementor_id;
        $job->technology_id = $request->technology_id;
        $job->created_by = auth()->user()->id;
        $job->save();

        // Save Job vendor
        $jv = new JobVendor;
        $jv->vendor_company_id = $request->vendor_company_id;
        $jv->vendor_id = $request->vendor_id;
        $jv->save();
        
        DB::commit();

        Alert('success', 'Job created successfully');
        return redirect(route('jobs.index'));
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Job  $job
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $job = Job::with(['client', 'vendor', 'implementor', 'creater', 'country', 'state', 'city'])->whereId($id)->first();

        $shared = ConsultantJob::with(['consultant'])->whereActive(1)->whereJob_id($id)->whereStatus('shared')->get();
        $scheduled = ConsultantJob::with(['consultant'])->whereActive(1)->whereJob_id($id)->whereStatus('scheduled')->get();
        $attended = ConsultantJob::with(['consultant'])->whereActive(1)->whereJob_id($id)->whereStatus('attended')->get();
        $selected = ConsultantJob::with(['consultant'])->whereActive(1)->whereJob_id($id)->whereStatus('selected')->get();
        $joined = ConsultantJob::with(['consultant'])->whereActive(1)->whereJob_id($id)->whereStatus('joined')->get();

        return view('jobs.show', compact('job', 'shared', 'scheduled', 'attended', 'selected', 'joined' ));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Job  $job
     * @return \Illuminate\Http\Response
     */
    public function edit(Job $job)
    {
        $countries = countrySelect();
        $states = stateSelect($job->country_id);
        $cities = citySelect($job->state_id);
        $technologies = technologySelect();
        $interview_modes = config('custom.interview_modes');
        $employment_types = config('custom.employment_types');
        $vendor_Companies = vendorCompanySelect();
        $vendors = vendorSelect();
        $clients = clientSelect();
        $implementors = implementorSelect();

    	return view('jobs.edit', compact('countries', 'states', 'cities', 'technologies', 'interview_modes', 'employment_types', 'vendor_Companies', 'vendors', 'clients', 'implementors', 'job'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Job  $job
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        DB::beginTransaction();
        $job = Job::find($id);
        $job->title = $request->title;
        $job->min_experience = $request->min_experience;
        $job->max_experience = $request->max_experience;
        $job->interview_mode = $request->interview_mode;
        $job->employment_type = $request->employment_type;
        $job->description = $request->description;
        $job->internal_message = $request->internal_message;
        $job->interview_address = $request->interview_address;
        $job->interview_address = $request->interview_address;
        $job->status = $request->status;
        $job->min_payrate = $request->min_payrate;
        $job->max_payrate = $request->max_payrate;
        $job->country_id = $request->country_id;
        $job->state_id = $request->state_id;
        $job->city_id = $request->city_id;
        $job->vendor_company_id = $request->vendor_company_id;
        $job->vendor_id = $request->vendor_id;
        $job->client_id = $request->client_id;
        $job->implementor_id = $request->implementor_id;
        $job->technology_id = $request->technology_id;
        $job->update();

        // Save Job vendor
        JobVendor::whereJob_id($id)->delete();
        
        $jv = new JobVendor;
        $jv->job_id = $job->id;
        $jv->vendor_company_id = $request->vendor_company_id;
        $jv->vendor_id = $request->vendor_id;
        $jv->save();

        DB::commit();

        Alert('success', 'Job updated successfully');
        return redirect(route('jobs.index'));
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Job  $job
     * @return \Illuminate\Http\Response
     */
    public function destroy(Job $job)
    {
        //
    }

    // Save schedule
    public function saveScheduled(Request $request)
    {
        if(is_null($request->share_id)) {
            Alert('Danger', 'Please select consultants');
            return back();
        }

        $jid = '';
        foreach ($request->share_id as $key => $value) {
            $share = ConsultantJob::find($value);
            $share->status = 'scheduled';
            $share->save();

            $jid = $share->job_id;
        }

        Alert('success', 'Consultnats status modified');
        return redirect('/jobs/'.$jid);
    }

    // Save Attender
    public function saveAttended(Request $request)
    {
        if(is_null($request->share_id)) {
            Alert('Danger', 'Please select consultants');
            return back();
        }

        $jid = '';
        foreach ($request->share_id as $key => $value) {
            $share = ConsultantJob::find($value);
            $share->status = 'attended';
            $share->save();

            $jid = $share->job_id;
        }

        Alert('success', 'Consultnats status modified');
        return redirect('/jobs/'.$jid);
    }

    // Save Attender
    public function saveSelected(Request $request)
    {
        if(is_null($request->share_id)) {
            Alert('Danger', 'Please select consultants');
            return back();
        }

        $jid = '';
        foreach ($request->share_id as $key => $value) {
            $share = ConsultantJob::find($value);
            $share->status = 'selected';
            $share->save();

            $jid = $share->job_id;
        }

        Alert('success', 'Consultnats status modified');
        return redirect('/jobs/'.$jid);
    }

    // Save Attender
    public function saveJoined(Request $request)
    {
        if(is_null($request->share_id)) {
            Alert('Danger', 'Please select consultants');
            return back();
        }

        $jid = '';
        foreach ($request->share_id as $key => $value) {
            $share = ConsultantJob::find($value);
            $share->status = 'joined';
            $share->save();

            $cid = $share->consultant_id;
            $jid = $share->job_id;

            // Updated consultant table for join
            Consultant::whereId($cid)->update(['status'=>'in_job']);
        }

        Alert('success', 'Consultnats status modified');
        return redirect('/jobs/'.$jid);
    }
}
