<?php

namespace App\Http\Controllers;

use Carbon\Carbon;
use App\Models\Consultant;
use Illuminate\Http\Request;
use App\Models\ConsultantAging;
use App\Models\IncentiveRequest;
use App\Models\IncentiveStructure;
use Illuminate\Support\Facades\DB;
use App\Models\ConsultantIncentive;
use App\Models\UserIncentiveStructure;

class IncentiveStructureController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $list = IncentiveStructure::latest()->get();

        return view('incentive-structures.index', compact('list'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('incentive-structures.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $structure = new IncentiveStructure;
        $structure->title = $request->title;
        $structure->marketing = $request->marketing;
        $structure->marketing_recurr = $request->marketing_recurr;
        $structure->in_job = $request->in_job;
        $structure->in_job_recurr = $request->in_job_recurr;
        $structure->job_bonus = $request->job_bonus;
        $structure->job_bonus_recurr = isset($request->job_bonus_recurr)?$request->job_bonus_recurr:0;
        $structure->yearly = $request->yearly;
        $structure->yearly_recurr = isset($request->yearly_recurr)?$request->yearly_recurr:0;
        $structure->created_by = auth()->user()->id;
        $structure->updated_by = auth()->user()->id;
        $structure->save();

        Alert('Success', 'Structure saved successfully');
        return back();
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\IncentiveStructure  $incentiveStructure
     * @return \Illuminate\Http\Response
     */
    public function show(IncentiveStructure $incentiveStructure)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\IncentiveStructure  $incentiveStructure
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $incentiveStructure = IncentiveStructure::with(['users'])->whereId($id)->first();

        return view('incentive-structures.edit', compact('incentiveStructure'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\IncentiveStructure  $incentiveStructure
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $structure = IncentiveStructure::find($id);
        $structure->title = $request->title;
        $structure->marketing = $request->marketing;
        $structure->marketing_recurr = $request->marketing_recurr;
        $structure->in_job = $request->in_job;
        $structure->in_job_recurr = $request->in_job_recurr;
        $structure->job_bonus = $request->job_bonus;
        $structure->job_bonus_recurr = isset($request->job_bonus_recurr)?$request->job_bonus_recurr:0;
        $structure->yearly = $request->yearly;
        $structure->yearly_recurr = isset($request->yearly_recurr)?$request->yearly_recurr:0;
        $structure->updated_by = auth()->user()->id;
        $structure->save();

        Alert('Success', 'Structure updated successfully');
        return back();
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\IncentiveStructure  $incentiveStructure
     * @return \Illuminate\Http\Response
     */
    public function destroy(IncentiveStructure $incentiveStructure)
    {
        //
    }

    public function assignStructure()
    {
        $users = userSelect();
        $structures = IncentiveStructure::pluck('title', 'id')->all();

        return view('incentive-structures.assign', compact('users', 'structures'));
    }

    public function getStructureDetails($id)
    {
        $structure = IncentiveStructure::find($id);

        return view('incentive-structures.details', compact('structure'));
    }

    public function saveStructureAssign(Request $request)
    {
        $us = new UserIncentiveStructure;
        $us->user_id = $request->user_id;
        $us->incentive_structure_id = $request->structure_id;
        $us->save();

        Alert('Success', 'Incentive structure assigned successfully');
        return back();
    }

    public function createIncentive()
    {
        $users = userSelect();
        $incentiveTypes = ['marketing'=>'Marketing', 'in_job'=>'In Job', 'job_bonus'=>'Job Bonus'];

        return view('incentive-structures.create-incentive', compact('users', 'incentiveTypes'));
    }

    public function getUserConsultants(Request $request)
    {
        return Consultant::whereCreated_by($request->uid)->pluck('name', 'id')->all();
    }

    public function saveIncentiveRequest(Request $request)
    {
        DB::beginTransaction();
        $incentive = new IncentiveRequest;        
        $incentive->user_id = $request->user_id;
        $incentive->consultant_id = $request->consultant_id;
        $incentive->type = $request->type;
        $incentive->amount = $request->amount;
        $incentive->created_by = auth()->user()->id;
        $incentive->save();
        DB::commit();

        Alert('success', 'Incentive Request saved successfully');
        return back();
    }

    public function incentiveRequests()
    {
        $list = IncentiveRequest::with(['user', 'consultant', 'creater'])->latest()->get();
        $incentiveTypes = ['marketing'=>'Marketing', 'in_job'=>'In Job', 'job_bonus'=>'Job Bonus'];
        $statuses = [1=>'applied', 2=>'Rejected', 3=>'Approved'];

        return view('incentive-structures.incentive-requests', compact('list', 'incentiveTypes', 'statuses'));
    }

    public function changeIncentiveStatus(Request $request)
    {
        DB::beginTransaction();
        $inc = IncentiveRequest::whereId($request->id)->first();
        $inc->status = $request->status;
        $inc->update();
        DB::commit();

        return 1;
    }

    public function incentivesYearly(Request $request)
    {
        $users = userSelect();
        
        return view('incentive-structures.yearly', compact('users'));
    }

    public function yearlyIncentivesDetails(Request $request)
    {
        $user_id = $request->userId;
        $year = $request->year;

        $list = array_unique(ConsultantIncentive::whereYear_id($year)->whereUser_id($user_id)->pluck('consultant_id')->all());
        
        $totallist = [];
        foreach($list as $consultant) {
            $months=[];
            for($i=1; $i<=12; $i++) {
                $incentive = ConsultantIncentive::whereConsultant_id($consultant)->whereYear_id($year)->whereMonth_id($i)->first();
                if($incentive != '') {
                    $total = $incentive->marketing + $incentive->in_job + $incentive->job_bonus;
                } else {
                    $total = 0;
                }

                $months[$i]=$total;
            }

            $name = Consultant::find($consultant)->name;
            array_push($totallist, (object)['name'=>$name, 'months'=>$months]);
            $months = [];
        }

        return view('incentive-structures.yearly-details-ajax', compact('totallist', 'year', 'user_id'));
    }

    public function incentiveDetails(Request $request)
    {
        $list = explode('-', $request->id);

        $incentive = ConsultantIncentive::with(['consultant'])->whereUser_id($list[2])->whereYear_id($list[1])->whereMonth_id($list[0])->first();

        return view('incentive-structures.ajax-details', compact('incentive'));
    }
}
