<?php

namespace App\Http\Controllers;

use Excel;
use App\Models\ImportedFile;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use App\Imports\ConsultantImport;
use Illuminate\Support\Facades\DB;

class ImportController extends Controller
{
    public function importConsultants()
    {
        $list = ImportedFile::with(['user'])->latest()->get();

        return view('consultants.import.create', compact('list'));
    }

    public function saveImportConsultants(Request $request)
    {
        // dd($request->all());
        $file = $request->file('csv_file');
        $fileExt = $file->getClientOriginalExtension();
        if($fileExt != 'csv') {
            Alert('danger', 'Please upload csv file');
            return back();
        }

        DB::beginTransaction();
        Excel::import(new ConsultantImport, $file);

        $fname = time().$file->getClientOriginalName();
        $file->move(public_path('/storage/csv-imports'), $fname);

        // Saving file
        $imf = new ImportedFile;
        $imf->user_id = auth()->user()->id;
        $imf->filename = $fname;
        $imf->save();
        DB::commit();

        Alert('success', 'File imported successfully');
        return redirect('/import_consultants');
    }

    public function downloadSampleFile()
    {
        $file= public_path(). "/storage/sample-csv.csv";

        return response()->download($file, 'sample-csv.csv');
    }

    public function saveImportedFile($id)
    {
        $fname = ImportedFile::find($id)->filename;
        $file= public_path(). "/storage/csv-imports/".$fname;;

        return response()->download($file, $fname);
    }
}
