<?php

namespace App\Http\Controllers;

use App\Models\Implementor;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class ImplementorController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $list = Implementor::with(['country', 'state', 'city', 'creater'])->latest()->get();

        return view('implementors.index', compact('list'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $countries = countrySelect();
        $states = stateSelect();
        $cities = citySelect();

        return view('implementors.create', compact('countries', 'states', 'cities'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        DB::beginTransaction();
        $implementor = new Implementor;
        $implementor->name = $request->name;
        $implementor->contact_name = $request->contact_name;
        $implementor->email = $request->email;
        $implementor->mobile = $request->mobile;
        $implementor->country_id = $request->country_id;
        $implementor->state_id = $request->state_id;
        $implementor->city_id = $request->city_id;
        $implementor->address = $request->address;
        $implementor->website = $request->website;
        $implementor->created_by = auth()->user()->id;
        $implementor->save();
        DB::commit();
        
        Alert('success', 'Implementor created.');
        return redirect(route('implementors.index'));
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Implementor  $implementor
     * @return \Illuminate\Http\Response
     */
    public function show(Implementor $implementor)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Implementor  $implementor
     * @return \Illuminate\Http\Response
     */
    public function edit(Implementor $implementor)
    {
        $countries = countrySelect();
        $states = stateSelect($implementor->country_id);
        $cities = citySelect($implementor->state_id);

        return view('implementors.edit', compact('countries', 'states', 'cities', 'implementor'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Implementor  $implementor
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        DB::beginTransaction();
        $implementor = Implementor::find($id);
        $implementor->name = $request->name;
        $implementor->contact_name = $request->contact_name;
        $implementor->email = $request->email;
        $implementor->mobile = $request->mobile;
        $implementor->country_id = $request->country_id;
        $implementor->state_id = $request->state_id;
        $implementor->city_id = $request->city_id;
        $implementor->address = $request->address;
        $implementor->website = $request->website;
        $implementor->update();
        DB::commit();
        
        Alert('success', 'Implementor updated.');
        return redirect(route('implementors.index'));
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Implementor  $implementor
     * @return \Illuminate\Http\Response
     */
    public function destroy(Implementor $implementor)
    {
        //
    }
}
