<?php

namespace App\Http\Controllers\Hr;

use App\Models\User;
use App\Models\CommonMail;
use App\Models\Consultant;
use App\Models\UserProfile;
use Illuminate\Http\Request;
use App\Models\ConsultantComment;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use App\Models\ConsultantTechnology;
use Illuminate\Support\Facades\Hash;

class HrEmployeeController extends Controller
{
    public function index()
    {
        $list = User::whereDepartment_id(5)->whereActive(1)->get();
        
        return view('hr.employees.index', compact('list'));
    }

    public function importEmployees()
    {
        $list = Consultant::whereStatus('in_job')->latest()->get();
        $statuses = config('custom.employee_statuses');
        $technologies = technologySelect();

        return view('hr.employees.import-employees', compact('list', 'statuses', 'technologies'));
    }

    public function create()
    {
        $data['company_id'] = auth()->user()->company_id;
        $data['countries'] = countrySelect();
        $data['usstates'] = stateSelect(231);
        $data['indstates'] = stateSelect(101);
        $data['states'] = stateSelect();
        $data['cities'] = citySelect();
        $data['technologies'] = technologySelect();
        $data['universities'] = universitySelect();
        $data['clients'] = clientSelect();
        $data['statuses'] = config('custom.employee_statuses');
        $data['guesthouses'] = guestHouseSelect();
        $data['vendor_companies'] = vendorCompanySelect();
        $data['vendors'] = vendorSelect();
        $data['visa_statuses'] = config('custom.visa_statuses');
        $data['opts'] = userSelect(3);
        $data['benchsales'] = userSelect(4);
        $data['trainers'] = userSelect(6);
        $data['payrates_intervals'] = config('custom.payrates_intervals');
        $data['consultant_reference'] = config('custom.consultant_reference');
        $data['batches'] = batchSelect();
        $data['recruiters'] = roleUserSelect(['opt_recruiter']);

        return view('hr.employees.create', $data);
    }

    public function store(Request $request)
    {
        /* Useful Variables */
        $company_id = auth()->user()->company_id;
        
        DB::beginTransaction();
        /* Save Consultant */
            $consultant = new Consultant;
            $consultant->company_id = $company_id;
            $consultant->name = ucwords($request->name);
            $consultant->email = $request->email;
            $consultant->mobile = $request->mobile;
            $consultant->date_of_birth = dbDateFormat($request->dob);
            $consultant->origin_country_id = $request->origin_country_id;
            $consultant->origin_state_id = $request->origin_state_id;
            $consultant->origin_city_id = $request->origin_city_id;
            $consultant->current_country_id = $request->current_country_id;
            $consultant->current_state_id = $request->current_state_id;
            $consultant->current_city_id = $request->current_city_id;
            $consultant->ssn = $request->ssn;
            $consultant->skype_id = $request->skype_id;
            $consultant->driving_licence = $request->driving_licence;
            $consultant->visa_status = $request->visa_status;
            $consultant->visa_start_date = $request->visa_start_date;
            $consultant->visa_end_date = $request->visa_end_date;
            $consultant->came_to_usa = $request->came_to_usa;
            $consultant->home_visit = $request->home_visit;
            $consultant->relocate = $request->relocate;
            $consultant->zipcode = $request->zipcode;
            $consultant->reference = $request->consultant_reference;
            $consultant->referer_name = $request->referer_name;
            $consultant->marital_status = $request->marital_status;
            $consultant->created_by = auth()->user()->id;
            if(isset($request->tech_recruiter_id)){
                $consultant->tech_recruiter_id = $request->tech_recruiter_id;
            }
            $consultant->created_ip = $request->ip();
            $consultant->status = $request->status;
            $consultant->save();
        /* Save Consultant Ends */

        /* Save Technologies */
        if(isset($consultant->id)) {
            $technologies = $request->technologies;
            if(count($technologies) > 0) {
                foreach($technologies as $tech) {
                    $ct = new ConsultantTechnology;
                    $ct->consultant_id = $consultant->id;
                    $ct->technology_id = $tech;
                    $ct->save();
                }
            }
        }

        /* Save Comments */
        if(isset($consultant->id) && $request->comments != NULL) {
            $ccmnt = new ConsultantComment;
            $ccmnt->consultant_id = $consultant->id;
            $ccmnt->comment = $request->comments;
            $ccmnt->user_id = auth()->user()->id;
            $ccmnt->save();
        }

        // Save User
        $user = new User;
        $user->company_id = $company_id;
        $user->name = $request->name;
        $user->email = $request->email;
        $user->mobile = $request->mobile;
        $user->department_id = 5;
        $user->country_id = $request->country_id;
        $user->state_id = $request->state_id;
        $user->city_id = $request->city_id;
        $user->parent_id = $request->parent_id;
        $user->password = Hash::make('12345678');
        $user->save();

        // Assign Role
        if($user) {
            $user->assignRole(13);
        } else {
            return back()->withErrors($validator)->withInput();
        }
        /* Saving User Profile */
        $profile = new UserProfile;
        $profile->user_id = $user->id;
        $profile->company_id = $company_id;
        $profile->join_date = date('Y-m-d');
        $profile->name = $request->mark_name;
        $profile->email = $request->mark_email;
        $profile->mobile = $request->mark_mobile;
        $profile->country_id = $request->mark_country_id;
        $profile->state_id = $request->mark_state_id;
        $profile->city_id = $request->mark_city_id;
        $profile->address = '';
        $profile->save();

        // Update consultant table
        $cn = Consultant::whereId($consultant->id)->update(['user_id'=>$user->id]);

        // On Success Send Email to user
        $content = '<p> please login into our application with below credentials</p><br>';
        $content .= '<a href="{{ url("/login") }}">Login</a>';
        $content .= '<p>>Username:- '.$user->email.'</p><br>';
        $content .= '<p>>Password:- 12345678</p><br>';
        CommonMail::sendHtml(env('MAIL_FROM_ADDRESS'), $user->email, 'User Credentials', $content);

        DB::commit();

        return 1;
    }
}
