<?php

namespace App\Http\Controllers\Hr;

use App\Models\User;
use App\Models\Consultant;
use App\Models\Department;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class HrDashboard extends Controller
{
    public function index()
    {
        /* Graph Data */
        $consultant_graph_count = [];
        $months = config('custom.months_names');

        foreach($months as $k=>$val){
            $count = Consultant::whereMonth('created_at', $k)->whereYear('created_at', date('Y'))->count();

            $consultant_graph_count[] = array('month'=>date('Y-'.$k),'count'=>$count);
        }

        $consultant_graph_count = json_encode($consultant_graph_count);
        /* End Graph */

        $employees = User::whereActive(1)->count();
        $departments = Department::count();
        $users = User::whereActive(1)->count();

        return view('hr.dashboard', compact('consultant_graph_count', 'employees', 'departments', 'users'));
    }
}
