<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index()
    {
        $user = auth()->user();
        
        if($user->hasRole('admin')) {
            return redirect(route('admin.dashboard'));
        }
        
        if($user->hasRole('opt_recruiter')) {
            return redirect(route('opt.dashboard'));
        }
        
        if($user->hasRole('opt_team_lead')) {
            return redirect(route('opt.lead-dashboard'));
        }
        
        if($user->hasRole('opt_manager')) {
            return redirect(route('opt.manager-dashboard'));
        }
        
        if($user->hasRole('benchsales_recruiter')) {
            return redirect(route('benchsales.dashboard'));
        }
        
        if($user->hasRole('benchsales_team_lead')) {
            return redirect(route('benchsales.lead-dashboard'));
        }
        
        if($user->hasRole('benchsales_manager')) {
            return redirect(route('benchsales.manager-dashboard'));
        }
        
        if($user->hasRole('accountant')) {
            return redirect(route('accounts.dashboard'));
        }
        
        if($user->hasRole('hr')) {
            return redirect(route('hr.dashboard'));
        }
        
        return view('home');
    }
}
