<?php

namespace App\Http\Controllers;

use App\Models\GuestHouse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Models\ConsultantGuesthouse;

class GuestHouseController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $list = Guesthouse::with(['creater'])->latest()->get();

        return view('guest-houses.index', compact('list'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $countries = countrySelect();
        $states = StateSelect();
        $cities = citySelect();
        
        return view('guest-houses.create', compact('countries', 'states', 'cities'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        DB::beginTransaction();
        $house = new Guesthouse;
        $house->name = $request->name;
        $house->capacity = $request->capacity;
        $house->country_id = $request->country_id;
        $house->state_id = $request->state_id;
        $house->city_id = $request->city_id;
        $house->address = $request->address;
        $house->created_by = auth()->user()->id;
        $house->save();
        DB::commit();
        
        Alert('success','Guesthouse Created Successfully');
        return redirect()->back();
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\GuestHouse  $guestHouse
     * @return \Illuminate\Http\Response
     */
    public function show(GuestHouse $guestHouse)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\GuestHouse  $guestHouse
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $guestHouse = GuestHouse::find($id);
        $countries = countrySelect();
        $states = StateSelect($guestHouse->country_id);
        $cities = citySelect($guestHouse->state_id);
        
        return view('guest-houses.edit', compact('countries', 'states', 'cities', 'guestHouse'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\GuestHouse  $guestHouse
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        DB::beginTransaction();
        $house = Guesthouse::find($id);
        $house->name = $request->name;
        $house->capacity = $request->capacity;
        $house->country_id = $request->country_id;
        $house->state_id = $request->state_id;
        $house->city_id = $request->city_id;
        $house->address = $request->address;
        $house->save();
        DB::commit();
        
        Alert('success','Guesthouse updated Successfully');
        return redirect(route('guesthouse.index'));
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\GuestHouse  $guestHouse
     * @return \Illuminate\Http\Response
     */
    public function destroy(GuestHouse $guestHouse)
    {
        //
    }

    public function allocated()
    {
        $list = ConsultantGuesthouse::with(['consultant', 'guesthouse'])->latest()->get();

        return view('guest-houses.allocated', compact('list'));
    }

    public function nonAllocated()
    {
        $allocated = array_unique(ConsultantGuesthouse::pluck('guest_house_id')->all());        
        $list = Guesthouse::whereNotIn('id', $allocated)->latest()->get();

        return view('guest-houses.index', compact('list'));
    }
}
