<?php

namespace App\Http\Controllers;

use Auth;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use Illuminate\Foundation\Bus\DispatchesJobs;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Routing\Controller as BaseController;

class Controller extends BaseController
{
    use AuthorizesRequests, DispatchesJobs, ValidatesRequests;

    public $user;

    public function __construct()
    {
        $this->user = auth()->user();
    }

    public function date_format_change_unique($value1 = null , $value2 = null){
        if(setting()->get('general.date_format') == 'm d Y'){
           $date1 = strtr($value1, '-', '/');
           $date2 = strtr($value2, '-', '/');
       }elseif(setting()->get('general.date_separator') == 'comma'){
           $date1 = strtr($value1, ',', '-');
           $date2 = strtr($value2, ',', '-');
       }else{
           $date1 = strtr($value1, '/', '-');
           $date2 = strtr($value2, '/', '-');
       }

       return [ $date1 , $date2 ]; 
    }

    public function formatDate($fdate)
    {
        $dt = $this->date_format_change_unique($fdate);
        return date('Y-m-d', strtotime($dt[0]));
    }
}
