<?php

namespace App\Http\Controllers;

use App\Models\Job;
use App\Models\Consultant;
use Illuminate\Http\Request;
use App\Models\ConsultantJob;
use Illuminate\Support\Facades\DB;
use RealRashid\SweetAlert\Facades\Alert;

class ConsultantJobController extends Controller
{
    public function jobsList()
    {
        $list = Job::with(['client', 'vendor', 'implementor', 'creater', 'country', 'state', 'city'])->latest()->get();

        return view('vendor-submissions.jobs', compact('list'));
    }

    public function jobConsultants($id)
    {
        $job = Job::with(['client', 'vendor', 'implementor', 'creater', 'country', 'state', 'city'])->whereId($id)->first();
        $appliedIds = array_unique(ConsultantJob::whereJob_id($id)->whereActive(1)->pluck('consultant_id')->all());
        $applied = Consultant::whereIn('id', $appliedIds)->get();
        $notapplied = Consultant::whereNotIn('id', $appliedIds)->get();

        return view('vendor-submissions.job-consultants', compact('job', 'applied', 'notapplied'));
    }

    public function saveJobConsultants(Request $request)
    {
        DB::beginTransaction();
        if(count($request->consultant_id) != 0) {
            for ($i=0; $i<count($request->consultant_id); $i++) {
                // Inactive previous with same job and consultant
                ConsultantJob::whereConsultant_id($request->consultant_id[$i])->whereJob_id($request->job_id)->update(['active'=>0]);

                $cj = new ConsultantJob;
                $cj->consultant_id = $request->consultant_id[$i];
                $cj->job_id = $request->job_id;
                $cj->created_by = auth()->user()->id;
                $cj->status = 'shared';
                $cj->payrate = $request->payrate;
                $cj->save();
            }
        }
        DB::commit();

        Alert('success', 'Consultants applied for the job');
        return redirect('/vs_jobs');
    }

    public function saveJoined(Request $request)
    {
        DB::beginTransaction();
        if(count($request->consultant_id) != 0) {
            for ($i=0; $i<count($request->consultant_id); $i++) {
                // Inactive previous with same job and consultant
                ConsultantJob::whereConsultant_id($request->consultant_id[$i])->whereJob_id($request->job_id)->update(['active'=>0]);
                
                $cj = new ConsultantJob;
                $cj->consultant_id = $request->consultant_id[$i];
                $cj->job_id = $request->job_id;
                $cj->created_by = auth()->user()->id;
                $cj->status = 'joined';
                $cj->payrate = $request->payrate;
                $cj->save();
            }
        }
        DB::commit();

        Alert('success', 'Consultants applied for the job');
        return redirect('/vs_jobs');
    }

    public function vsConsultants()
    {
        $list = Consultant::with(['technologies'])->where('status', '!=', 'in_job')->whereCreated_by(auth()->user()->id)->latest()->get();
        $statuses = config('custom.employee_statuses');
        $technologies = technologySelect();

        return view('vendor-submissions.consultants', compact('list', 'statuses', 'technologies'));
    }

    public function consultantJobs($id)
    {
        $consultant = Consultant::find($id);
        $appliedIds = array_unique(ConsultantJob::whereConsultant_id($id)->whereActive(1)->pluck('job_id')->all());
        $applied = Job::whereIn('id', $appliedIds)->get();
        $notapplied = Job::whereNotIn('id', $appliedIds)->get();

        return view('vendor-submissions.consultant-jobs', compact('consultant', 'applied', 'notapplied'));
    }

    public function saveConsultantsJobs(Request $request)
    {
        DB::beginTransaction();
        if(count($request->job_id) != 0) {
            for ($i=0; $i<count($request->job_id); $i++) {
                // Inactive previous with same job and consultant
                ConsultantJob::whereConsultant_id($request->consultant_id)->whereJob_id($request->job_id[$i])->update(['active'=>0]);
                
                $cj = new ConsultantJob;
                $cj->consultant_id = $request->consultant_id;
                $cj->job_id = $request->job_id[$i];
                $cj->created_by = auth()->user()->id;
                $cj->status = 'shared';
                $cj->payrate = $request->payrate;
                $cj->save();
            }
        }
        DB::commit();

        Alert('success', 'Jobs applied for the consultant');
        return redirect('/vs_consultants');
    }
}
