<?php

namespace App\Http\Controllers;

use App\Models\ConsultantCall;
use Illuminate\Http\Request;

class ConsultantCallController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $uuids = userUserIds();
        $list = ConsultantCall::with(['callby', 'consultant'])->whereIn('call_by', $uuids)->latest()->get();
        $consultants = consultantSelect();
        $call_statues = config('custom.call_statuses');

        return view('consultants.calls.index', compact('list', 'consultants', 'call_statues'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $call = new ConsultantCall;
        $call->consultant_id = $request->consultant_id;
        $call->call_status = $request->call_status;
        $call->duration = $request->duration;
        $call->comments = $request->comments;
        $call->callback_date = $request->callback_date;
        if($request->call_status == 'call_me_later') {
            $call->status = 1;
        }
        $call->call_by = auth()->user()->id;
        $call->save();

        if($request->ajax()) {
            $ccall = ConsultantCall::with(['consultant'])->whereId($call->id)->first();
            return [
                    'id'=>$ccall->id,
                    'name'=>$ccall->consultant->name,
                    'call_status'=>$ccall->call_status,
                    'comments'=>$ccall->comments,
                    'callback_date'=>($ccall->callback_date!='')?date(env('APP_DATE'), strtotime($call->callback_date)):''
                    ];
        } else {
            return redirect(route('calls.index'));
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\ConsultantCall  $consultantCall
     * @return \Illuminate\Http\Response
     */
    public function show(ConsultantCall $consultantCall)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\ConsultantCall  $consultantCall
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $call = ConsultantCall::find($id);
        $consultants = consultantSelect();
        $call_statues = config('custom.call_statuses');

        return view('consultants.calls.edit', compact('call', 'consultants', 'call_statues'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\ConsultantCall  $consultantCall
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, ConsultantCall $consultantCall)
    {
        $call = ConsultantCall::find($id);
        $call->student_id = isset($request->consultant_id)?$request->consultant_id:0;
        $call->status = isset($request->call_status)?$request->call_status:'';
        $call->comments = isset($request->comments)?$request->comments:'';
        $call->duration = isset($request->time)?$request->time:'';
        $call->created_at = date('Y-m-d H:i:s');
        $call->call_me_date = isset($request->callback_date)?$this->formatDate($request->callback_date):'';
        $call->update();

        if($call){
            return redirect(route('calls.index'))->with('success','Call Updated Successfully');
        }else{
            return redirect(route('calls.index'))->with('error','Failed to Update Call list. Please try again.');
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\ConsultantCall  $consultantCall
     * @return \Illuminate\Http\Response
     */
    public function destroy(ConsultantCall $consultantCall)
    {
        //
    }
}
