<?php

namespace App\Http\Controllers;

use App\Models\College;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class CollegeController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $list = College::latest()->get();

        return view('colleges.index', compact('list'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $countries = countrySelect();
        $states = stateSelect();
        $cities = citySelect();
        
        return view('colleges.create', compact('countries', 'states', 'cities'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        DB::beginTransaction();
        $college = new College;;
        $college->name = $request->name;
        $college->contact_name = $request->contact_name;
        $college->mobile = $request->mobile;
        $college->email = $request->email;
        $college->country_id = $request->country_id;
        $college->state_id = $request->state_id;
        $college->city_id = $request->city_id;
        $college->address = $request->address;
        $college->save();
        DB::commit();

        Alert('success', 'College added successfully');
        return redirect('/college');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\College  $college
     * @return \Illuminate\Http\Response
     */
    public function show(College $college)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\College  $college
     * @return \Illuminate\Http\Response
     */
    public function edit(College $college)
    {
        $countries = countrySelect();
        $states = stateSelect($college->country_id);
        $cities = citySelect($college->state_id);
        
        return view('colleges.edit', compact('countries', 'states', 'cities', 'college'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\College  $college
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        DB::beginTransaction();
        $college = College::find($id);
        $college->name = $request->name;
        $college->contact_name = $request->contact_name;
        $college->mobile = $request->mobile;
        $college->email = $request->email;
        $college->country_id = $request->country_id;
        $college->state_id = $request->state_id;
        $college->city_id = $request->city_id;
        $college->address = $request->address;
        $college->save();
        DB::commit();

        Alert('success', 'College updated successfully');
        return redirect('/college');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\College  $college
     * @return \Illuminate\Http\Response
     */
    public function destroy(College $college)
    {
        //
    }
}
