<?php

namespace App\Http\Controllers;

use App\Models\Client;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class ClientController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $list = Client::with(['country', 'state', 'city', 'creater'])->latest()->get();
        $title = 'Clients list';

        return view('clients.index', compact('list', 'title'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $countries = countrySelect();
        $states = stateSelect();
        $cities = citySelect();

        return view('clients.create', compact('countries', 'states', 'cities'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        DB::beginTransaction();
        $client = new Client;
        $client->name = $request->name;
        $client->email = $request->email;
        $client->mobile = $request->mobile;
        $client->country_id = $request->country_id;
        $client->state_id = $request->state_id;
        $client->city_id = $request->city_id;
        $client->address = $request->address;
        $client->website = $request->website;
        $client->created_by = auth()->user()->id;
        $client->save();
        DB::commit();
        
        Alert('success', 'Client created.');
        return redirect(route('clients.index'));
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Client  $client
     * @return \Illuminate\Http\Response
     */
    public function show(Client $client)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Client  $client
     * @return \Illuminate\Http\Response
     */
    public function edit(Client $client)
    {
        $countries = countrySelect();
        $states = stateSelect($client->country_id);
        $cities = citySelect($client->state_id);

        return view('clients.edit', compact('countries', 'states', 'cities', 'client'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Client  $client
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        DB::beginTransaction();
        $client = Client::find($id);
        $client->name = $request->name;
        $client->email = $request->email;
        $client->mobile = $request->mobile;
        $client->country_id = $request->country_id;
        $client->state_id = $request->state_id;
        $client->city_id = $request->city_id;
        $client->address = $request->address;
        $client->website = $request->website;
        $client->update();
        DB::commit();
        
        Alert('success', 'Client updated.');
        return redirect(route('clients.index'));
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Client  $client
     * @return \Illuminate\Http\Response
     */
    public function destroy(Client $client)
    {
        //
    }
}
