<?php

namespace App\Http\Controllers;

use DB;
use Auth;
use Entrust;
use App\Models\User;
use Activitykim;
use App\Receiver;
use App\Models\Teamchat;
use App\Models\Message_chat;
use App\Mail\ChatHistory;
use App\Events\ChatsEvent;
use App\Events\MessageSent;
use App\Events\ChatCountAll;
use Illuminate\Http\Request;
use App\Events\MessagePosted;
use App\Models\Message;
use App\Models\Conversation;
use Illuminate\Support\Facades\Log;

class ChatController extends Controller
{
    public function chat()
	{
        return view('chat');
    }

    public function send(Request $request)
	{
   		$user = User::find(Auth::user()->id);

   		$chat = new Teamchat();
   		$chat->user_id = Auth::user()->id;
   		$chat->company_id = Auth::user()->company_id;
   		$chat->message = $request->message;     
   		$chat->save();

      broadcast(new ChatsEvent($request->message, $user))->toOthers();

       return ['statsu'=>'OK'];
    }


   	public function olddata()
    {   		
        return \Response::json(Teamchat::join('users','users.id','=','team_chat.user_id')->select('team_chat.user_id as user','team_chat.message as message','team_chat.created_at as time','users.name as name')->orderBy('team_chat.id','asc')->get());
   	}

    public function  messages($userId)
	{
      $authUserId = Auth::user()->id;
   
      $output = DB::table('message_chats')
          ->leftJoin('users','users.id',  '=',  'message_chats.user_id')
          ->join('receivers','receivers.message_id','=','message_chats.id')
          ->where('message_chats.user_id','=',$authUserId)
          ->where('receivers.user_id','=',$userId)
          ->orWhere('message_chats.user_id','=',$userId)
          ->where('receivers.user_id','=',$authUserId)
          ->select('users.name as user','users.profile_image','users.profile_image','users.id as userId','message_chats.message','message_chats.file_path','message_chats.file_name','message_chats.type','message_chats.created_at as time','receivers.user_id as r_user_id')
          ->orderBy("message_chats.id","asc")
          ->get();
      	
		  return $output;
    }

    public function messagespost(Request $request,$userId)
	{
      $user = Auth::user();

      $message = new Message_chat(); 
      $message->message = $request->message;
      $message->type    = $request->type;
      $message->user_id    = Auth::user()->id;
      $message->save();      

      $recever = new Receiver;
      $recever->message_id = $message->id;
      $recever->user_id = $userId;
      $recever->save();
    
      // new message has beed posted
      broadcast(new MessagePosted($message,$user,$userId))->toOthers();
      $output['message'] = $message;
      $output['user'] = $user;
      return ['output'=> $output];
    }

    public function fileupload($userId)
    {
      $file = request('file');
      $user = Auth::user();
      if (!empty($file)) {
        $fileName = $file->getClientOriginalName();
        // file with path
        $filePath = url('uploads/chats/'.$fileName);
        //Move Uploaded File
        $destinationPath = 'uploads/chats';
        if($file->move($destinationPath,$fileName)) {
            $request['file_path'] = $filePath;
            $request['file_name'] = $fileName;
            $request['message'] = 'file';
            $request['type'] = request('type');
        }

        $message = $user->messages()->create($request);

      $message->receivers()->create([
          'user_id'=>$userId
        ]);

      $output = [];
      broadcast(new MessagePosted($message,$user,$userId))->toOthers();

      $output['message'] = $message;
      $output['user'] = $user;
      return ['output'=> $output];

      }
    }

    public function online_users_list()
    {
      $authUserId = Auth::user()->id;
      $expiry_time = \Carbon\Carbon::now()->addMinutes(5)->getTimestamp();
      $users = DB::table('cache')->join('users','users.id','=','cache.key')->select('users.id as id','users.name as name')->where('expiration','<=',$expiry_time)->where('users.id','!=',$authUserId)->get();
      //$users = Activitykim::usersByHours(1)->where('user_id','!=',$authUserId)->get();

      return $users;
    }

    // Personal Chat Active Users List
    public function activeusers()
    {            
        $users_data = User::whereActive('1')->where('users.id','!=', auth()->user()->id)->get();
            
        $users = [];

        foreach($users_data  as $user){
            $users[] = $user;
        }
        
        return  $users;
    }

	/**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $user_id = Auth::id();
        $user = Auth::user();

        $conversation_user =  Conversation::where('id',$request->conversation_id)->whereUser1(Auth::id())->first();

        if($conversation_user){
            $reciever_id = $conversation_user->user2;
        }else{
            $reciever = Conversation::where('id',$request->conversation_id)->first();
            $reciever_id = $reciever->user1;
        }

        $message = new Message;
        $message->user_id = $user_id;
        $message->reciever_id = $reciever_id;
        $message->message = $request->message;
        $message->conversation_id = $request->conversation_id;
        $message->created_at = date('Y-m-d H:i:s');
        $message->save();
        
        broadcast(new MessageSent($user, $message, $request->conversation_id,$reciever_id))->toOthers();
        broadcast(new ChatCountAll($reciever_id));

        return ['status' => 'Message Sent!'];
    }

	/**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $user = Auth::user();
        $user_id = Auth::id();
        $reciever_id = $id;
        $reciever = User::find($id);
        $reciever = ['name'=>ucwords($reciever->name), 'id'=>$reciever->id];

        $count1 = Conversation::whereUser1($user_id)->whereUser2($reciever_id)->count();
        $count2 = Conversation::whereUser2($user_id)->whereUser1($reciever_id)->count();

        if($count1) {
            $conversation_id = Conversation::whereUser1($user_id)->whereUser2($reciever_id)->first()->id;

        }else if($count2) {
            $conversation_id = Conversation::whereUser2($user_id)->whereUser1($reciever_id)->first()->id;

        }else {
            $conv = new Conversation;
            $conv->company_id = auth()->user()->company_id;
            $conv->user1 = $user_id;
            $conv->user2 = $reciever_id;
            $conv->save();

            $conversation_id = $conv->id;  

        }

        return ['message'=> Message::with(['user'])->whereConversation_id($conversation_id)->get(), 'conversation_id'=>$conversation_id,'reciever'=>$reciever];
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function chatHistory($id)
    {
        $user_id = Auth::id();
        $reciever_id = $id;
        $user_email = Auth::user()->email;
        $count1 = Conversation::whereUser1($user_id)->whereUser2($reciever_id)->count();
        if($count1 != 0) {
            $conversation_id = Conversation::whereUser1($user_id)->whereUser2($reciever_id)->first()->id;

        }else{
            $conversation_id = Conversation::whereUser2($user_id)->whereUser1($reciever_id)->first()->id;
        }

        $date = date('Y-m-d' .' '.'23:00:00');
        $weekdate = date('Y-m-d' .' '.'24:60:60',strtotime("-7 days")); 

        $message = Message::with(['user'])->whereConversation_id($conversation_id)->whereBetween('created_at',[$weekdate,$date])->get();


        return \Mail::to(['brvk007@gmail.com'])
                ->send(new ChatHistory($message)); 

    }
}
