<?php

namespace App\Http\Controllers;

use Date;
use App\Models\Consultant;
use Illuminate\Http\Request;

class CardListingController extends Controller
{
    public function getCardData(Request $request)
    {
        $myId = auth()->user()->id;
        $uuids = userUserIds();
        $dates = explode('-', $request->dates);
        $rdates = [date('Y-m-d', strtotime($dates[0])), date('Y-m-d', strtotime($dates[1] . ' +1 day'))];

        if(isAdmin()) {
            $card1 = Consultant::count();
            $card2 = Consultant::whereStatus('enquiry')->whereBetween('created_at', $rdates)->count();
            $card3 = Consultant::whereStatus('prospects')->whereBetween('created_at', $rdates)->count();
            $card4 = Consultant::whereStatus('in_training')->whereBetween('created_at', $rdates)->count();
            $card5 = Consultant::whereBetween('status', ['on_bench', 'open_bench'])->whereBetween('created_at', $rdates)->count();
            $card6 = Consultant::whereStatus('in_job')->whereBetween('created_at', $rdates)->count();
            $card7 = Consultant::whereStatus('dropped')->whereBetween('created_at', $rdates)->count();
        } else {
            $card1 = Consultant::whereIn('created_by', $uuids)->whereBetween('created_at', $rdates)->count();
            $card2 = Consultant::whereStatus('enquiry')->whereBetween('created_at', $rdates)->whereIn('created_by', $uuids)->count();
            $card3 = Consultant::whereStatus('prospects')->whereBetween('created_at', $rdates)->whereIn('created_by', $uuids)->count();
            $card4 = Consultant::whereStatus('in_training')->whereBetween('created_at', $rdates)->whereIn('created_by', $uuids)->count();
            $card5 = Consultant::whereIn('status', ['on_bench', 'open_bench'])->whereBetween('created_at', $rdates)->whereIn('created_by', $uuids)->count();
            $card6 = Consultant::whereStatus('in_job')->whereBetween('created_at', $rdates)->whereIn('created_by', $uuids)->count();
            $card7 = Consultant::whereStatus('dropped')->whereBetween('created_at', $rdates)->whereIn('created_by', $uuids)->count();
        }

        return [
            'card1'=>$card1,
            'card2'=>$card2,
            'card3'=>$card3,
            'card4'=>$card4,
            'card5'=>$card5,
            'card6'=>$card6,
            'card7'=>$card7
        ];
    }

    public function consultantList(Request $request)
    {
        $type = $request->type;
        $rdates = explode(' - ', $request->list_dates);
        $date1 = Date::parse($rdates[0])->format('Y-m-d');
        $date2 = Date::parse($rdates[1])->format('Y-m-d');
        $newDates = [$date1, $date2];
        
        $list = Consultant::with(['technologies']);
        $myId = auth()->user()->id;
        $uuids = userUserIds();

        if($type != 'all') {
            $list = Consultant::with(['technologies'])->whereStatus($type);
        }

        // If OPT
        if(!isAdmin()) {
            $list = $list->whereIn('created_by', $uuids);
        }  

        $list = $list->whereBetween('created_at', $newDates)->latest()->get();

        $statuses = config('custom.employee_statuses');
        $technologies = technologySelect();
        $list_type = $type;
        $list_dates = $request->list_dates;
        return view('consultants.index-listing', compact('list', 'statuses', 'technologies', 'list_type', 'list_dates'));
    }

    public function visaConsultantList(Request $request, $type1=null)
    {
        $myId = auth()->user()->id;
        $uuids = userUserIds();

        $list = Consultant::with(['technologies']);

        if($type1 != '') {
            $list = Consultant::with(['technologies'])->whereVisa_status($type1);
        }

        // If OPT
        if(!isAdmin()) {
            $list = $list->whereIn('created_by', $uuids);
        }  

        $list = $list->latest()->get();

        $statuses = config('custom.employee_statuses');
        $technologies = technologySelect();
        return view('consultants.index', compact('list', 'statuses', 'technologies'));
    }
}
