<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\CampaignContact;
use App\Models\CampaignUnsubscriber;
use Maatwebsite\Excel\Facades\Excel;
use App\Imports\CampaignUnsubscriberImport;

class CampaignUnsubscriberController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $data['list'] = CampaignUnsubscriber::paginate(100);

        return view('mail-campaign.unsubscribers.list', $data);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\CampaignUnsubscriber  $campaignUnsubscriber
     * @return \Illuminate\Http\Response
     */
    public function show(CampaignUnsubscriber $campaignUnsubscriber)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\CampaignUnsubscriber  $campaignUnsubscriber
     * @return \Illuminate\Http\Response
     */
    public function edit(CampaignUnsubscriber $campaignUnsubscriber)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\CampaignUnsubscriber  $campaignUnsubscriber
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, CampaignUnsubscriber $campaignUnsubscriber)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\CampaignUnsubscriber  $campaignUnsubscriber
     * @return \Illuminate\Http\Response
     */
    public function destroy(CampaignUnsubscriber $campaignUnsubscriber)
    {
        //
    }

    public function import(Request $request)
    {
        Excel::import(new CampaignUnsubscriberImport, $request->file('files'));
        
        Alert('success', 'All good!');
        return redirect('/campaign_unsubscribers');
    }

    public function action(Request $request)
    {
        if($request->type == 0) {
            CampaignContact::whereIn('email', $request->reqList)->update(['status'=>0]);
        }else {
            CampaignContact::whereIn('email', $request->reqList)->update(['status'=>1]);
        }

        CampaignUnsubscriber::whereIn('email', $request->reqList)->delete();
    }
}
