<?php

namespace App\Http\Controllers;

use App\Models\CampaignTemplate;
use Illuminate\Http\Request;

class CampaignTemplateController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        if($request->ajax()) {
            if(isAdmin()) {
                $data['list'] = CampaignTemplate::paginate(100);
            }else {
                $data['list'] = CampaignTemplate::whereUser_id(auth()->user()->id)->paginate(100);
            }

            return view('mail-campaign.templates.list', $data);
        }

        return view('mail-campaign.templates.index');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('mail-campaign.templates.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $template = new CampaignTemplate;
        $template->title = $request->title;
        $template->content = $request->content;
        $template->user_id = auth()->user()->id;
        
        if($template->save()) {
            Alert('success', 'Template Created Successfully!..');            
            return back();
        } else{
            Alert('danger', 'Something Went Wrong.');
            return back();
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\CampaignTemplate  $campaignTemplate
     * @return \Illuminate\Http\Response
     */
    public function show(CampaignTemplate $campaignTemplate)
    {
        return view('mail-campaign.templates.show', compact('campaignTemplate'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\CampaignTemplate  $campaignTemplate
     * @return \Illuminate\Http\Response
     */
    public function edit(CampaignTemplate $campaignTemplate)
    {
        return view('mail-campaign.templates.edit', compact('campaignTemplate'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\CampaignTemplate  $campaignTemplate
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, CampaignTemplate $campaignTemplate)
    {
        $template = CampaignTemplate::findOrFail($campaignTemplate->id);
        $template->title = $request->title;
        $template->content = $request->content;
        
        if($template->save()) {
            Alert('success', 'Template Updated Successfully!..');            
            return back();
        } else{
            Alert('danger', 'Something Went Wrong.');
            return back();
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\CampaignTemplate  $campaignTemplate
     * @return \Illuminate\Http\Response
     */
    public function destroy(CampaignTemplate $campaignTemplate)
    {
        //
    }
}
