<?php

namespace App\Http\Controllers;

use Excel;
use App\Models\CampaignList;
use Illuminate\Http\Request;
use App\Models\CampaignContact;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use App\Exports\CampaignContactCustomExport;

class CampaignListController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        if($request->ajax()) {
            if(isAdmin()) {
                $list = CampaignList::paginate(100);
            }else {
                $list = CampaignList::whereUser_id(Auth::id())->paginate(100);
            }

            return view('mail-campaign.lists.list', compact('list'));
        }

        return view('mail-campaign.lists.index');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('mail-campaign.lists.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request['user_id'] = auth()->user()->id;

        DB::beginTransaction();        
        if(CampaignList::create($request->all())) {
            Alert('success', 'List Created Successfully!..');
            DB::commit();
            return redirect('/campaign_lists')->with('success', 'List Created Successfully!..');            
        } else{
            Alert('danger', 'Something Went Wrong.');
            return redirect('/campaign_lists')->with('danger', 'Something Went Wrong.');
        }    
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\CampaignList  $campaignList
     * @return \Illuminate\Http\Response
     */
    public function show(CampaignList $campaignList)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\CampaignList  $campaignList
     * @return \Illuminate\Http\Response
     */
    public function edit(CampaignList $campaignList)
    {
        return view('mail-campaign.lists.edit', compact('campaignList'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\CampaignList  $campaignList
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        DB::beginTransaction();
        $list = CampaignList::find($id);
        if($list->fill($request->all())->save()) {
            Alert('success', 'List Updated Successfully!..');  
            DB::commit();          
            return back();
        } else{
            Alert('danger', 'Something Went Wrong.');
            return back();
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\CampaignList  $campaignList
     * @return \Illuminate\Http\Response
     */
    public function destroy(CampaignList $campaignList)
    {
        //
    }

    // Exporting
    public function export(Request $request, $id, $type)
    {
        return (new CampaignContactCustomExport($id))->download('list-contacts.'.$type);
    }
}
