<?php

namespace App\Http\Controllers;

use App\Models\Campaign;
use App\Models\CommonMail;
use App\Models\SingleMail;
use App\Models\CampaignList;
use Illuminate\Http\Request;
use App\Models\CampaignContact;
use App\Models\CampaignTemplate;
use Illuminate\Support\Facades\Auth;

class CampaignController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        if($request->ajax()) {
            if (isAdmin()) {
                $data['list'] = Campaign::whereCreater_id(Auth::user()->id)->paginate(100);
            } else {
                $data['list'] = Campaign::paginate(100);
            }     

            return view('mail-campaign.campaigns.list', $data);
        }

        return view('mail-campaign.campaigns.index');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        if (isAdmin()) {
            $data['titles'] = CampaignList::pluck('title', 'id')->all();
            $data['templates'] = CampaignTemplate::pluck('title', 'id')->all();
        } else {
            $data['titles'] = CampaignList::whereUser_id(Auth::id())->pluck('title', 'id')->all();
            $data['templates'] = CampaignTemplate::whereUser_id(Auth::id())->pluck('title', 'id')->all();
        }     

        return view('mail-campaign.campaigns.create', $data);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request['status'] = $request->create_campaign;
        $request['creater_id'] = Auth::user()->id;
        $request['from_address'] = $request->from_add;
        
        if($request->create_campaign == 0){
            set_time_limit(3600);/*Changing PHP Execution time*/

            $from = $request->from_add;
            
            $from_filtr = explode('@', $from);
            if($from_filtr[1] != env('MAIL_DOMAIN', '9thnetworks.com')) {
                $from = $from_filtr[0].'@'.env('MAIL_DOMAIN', '9thnetworks.com');
            }

            if($request->list_id != '0') {
                $emails = CampaignContact::whereList_id($request->list_id)->active()->pluck('email')->all();

            } else{
                if (Entrust::hasRole('admin')) {
                    $emails = CampaignContact::whereNull('list_id')->active()->pluck('email')->all();   
                }else{
                    $emails = CampaignContact::whereUser_id(Auth::id())->whereNull('list_id')->active()->pluck('email')->all();   
                }                     
            }

            $filtered = array_unique($emails);
            
            // dispatch(new SendEmailJob($filtered, $request->content, $from, $request->subject));
            foreach (array_chunk($filtered, 500) as $value) {
                CommonMail::sendHtml($from, $value, $request->subject, $request->content);
            }

            if ($request->as_new == 'on') {
                $template = new CampaignTemplate;
                $template->title = $request->template_title;
                $template->user_id = Auth::id();
                $template->title = date('d M Y H:i:s');
                $template->content = $request->content;
                $template->save();
            }
            
            Campaign::create($request->all());
           return back()->with('success', 'Saved And Send  Successfully');

        }elseif($request->create_campaign == 2){

            if ($request->as_new == 'on') {
                $template = new CampaignTemplate;
                $template->title = $request->template_title;
                $template->user_id = Auth::id();
                $template->title = date('d M Y H:i:s');
                $template->content = $request->content;
                $template->save();
            }
            
            $request['template_id'] = $template->id;
            $request['user_id'] = Auth::id();
            Campaign::create($request->all());

            return back()->with('success', 'Saved As Drafts');
        }else{          
            set_time_limit(3600);/*Changing PHP Execution time*/

            $from = $request->from_add;
            
            $from_filtr = explode('@', $from);
            if($from_filtr[1] != env('MAIL_DOMAIN', 'r10networks.com')) {
                $from = $from_filtr[0].'@'.env('MAIL_DOMAIN', 'r10networks.com');
            }

            if($request->list_id != '0') {
                $emails = CampaignContact::whereList_id($request->list_id)->active()->pluck('email')->all();

            } else{
                if (isAdmin()) {
                    $emails = CampaignContact::whereNull('list_id')->active()->pluck('email')->all();   
                }else{
                    $emails = CampaignContact::whereUser_id(Auth::id())->whereNull('list_id')->active()->pluck('email')->all();   
                }                     
            }
            
            $filtered = array_unique($emails);
            
            // dispatch(new SendEmailJob($filtered, $request->content, $from, $request->subject));
            foreach (array_chunk($filtered, 500) as $value) {
                CommonMail::sendHtml($from, $value, $request->subject, $request->content);
            }

            if ($request->as_new == 'on') {
                $template = new CampaignTemplate;
                $template->title = $request->template_title;
                $template->user_id = Auth::id();
                $template->title = date('d M Y H:i:s');
                $template->content = $request->content;
                $template->save();
            }

            Alert('success', 'Mail Sent Successfully!.');
            return back();
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Campaign  $campaign
     * @return \Illuminate\Http\Response
     */
    public function show(Campaign $campaign)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Campaign  $campaign
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        if (isAdmin()) {
            $data['titles'] = CampaignList::pluck('title', 'id')->all();
            $data['templates'] = CampaignTemplate::pluck('title', 'id')->all();
        } else {
            $data['titles'] = CampaignList::whereUser_id(Auth::id())->pluck('title', 'id')->all();
            $data['templates'] = CampaignTemplate::whereUser_id(Auth::id())->pluck('title', 'id')->all();
        }     

        $data['campaign'] = Campaign::with(['template'])->whereId($id)->first();

        return view('mail-campaign.campaigns.edit', $data);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Campaign  $campaign
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Campaign $campaign)
    {
        // dd($request->all());
        if($request->create_campaign == 1) {
            if ($request->as_new == 'on') {
                $template = new CampaignTemplate;
            
                $template->title = $request->template_title;
            } else {
                $template = CampaignTemplate::find($request->template_id);
            }
            $template->user_id = Auth::id();
            $template->content = $request->content;
            $template->update();

            $tpid = $template->id;

            $request['template_id'] = $tpid;

            $campaign->fill($request->all())->save();
        }

        if($request->create_campaign == 2) {
            if ($request->as_new == 'on') {
                $template = new CampaignTemplate;
                $template->title = $request->template_title;
                $template->user_id = Auth::id();
                $template->title = date('d M Y H:i:s');
                $template->content = $request->content;
                $template->save();

                $tpid = $template->id;
            } else {
                $tpid = $request->template_id;
            }

            $request['template_id'] = $tpid;

            $campaign->fill($request->all())->save();

            set_time_limit(3600);/*Changing PHP Execution time*/

            $from = $request->from_add;
            
            $from_filtr = explode('@', $from);
            if($from_filtr[1] != env('MAIL_DOMAIN', 'r10networks.com.com')) {
                $from = $from_filtr[0].'@'.env('MAIL_DOMAIN', 'r10networks.com.com');
            }

            if($request->list_id != '0') {
                $emails = CampaignContact::whereList_id($request->list_id)->active()->pluck('email')->all();

            } else{
                if (Entrust::hasRole('admin')) {
                    $emails = CampaignContact::whereNull('list_id')->active()->pluck('email')->all();   
                }else{
                    $emails = CampaignContact::whereUser_id(Auth::id())->whereNull('list_id')->active()->pluck('email')->all();   
                }                     
            }

            $filtered = array_unique($emails);

            foreach (array_chunk($filtered, 500) as $value) {
                CommonMail::sendHtml($from, $value, $request->subject, $request->content);
            }

            /* foreach(array_chunk($filtered, 1500) as $k=>$result ){
                Mail::to($result)->send(new BulkMail($request->content, $from, $request->subject));
            } */

            $mail_data['content'] = $request->content;
            $mail_data['filtered'] = $filtered;
            $mail_data['from'] = $from; 
            $mail_data['subject'] = $request->subject;

            //$this->dispatch(new SendBulkMail($mail_data));
        }

        return back()->with('success', 'Campaign updated successfully!.');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Campaign  $campaign
     * @return \Illuminate\Http\Response
     */
    public function destroy(Campaign $campaign)
    {
        //
    }

    public function single()
    {
        if (isAdmin()) {
            $data['templates'] = CampaignTemplate::pluck('title', 'id')->all();
        } else {
            $data['templates'] = CampaignTemplate::whereUser_id(Auth::id())->pluck('title', 'id')->all();
        }        

        return view('mail-campaign.campaigns.single', $data);
    }

    public function singleSave(Request $request)
    {
        $to_add = $request->to_add;
        // $cc = $request->cc;
        // $bcc = $request->bcc;
        $from = $request->from;
        $subject = $request->subject;
        $content = $request->content;

        if ($to_add != '') {
            // Saving Into DB
            $single = new SingleMail;
            $single->user_id = Auth::id();
            $single->to_add = $to_add;
            // $single->cc = $cc;
            // $single->bcc = $bcc;
            $single->from = $from;
            $single->subject = $subject;
            $single->content = $content;
            $single->save();

            CommonMail::sendHtml($from, $to_add, $subject, $single->content);

            if ($request->as_new == 'on') {
                $template = new CampaignTemplate;
                $template->user_id = Auth::id();
                $template->title = $request->template_title.' '.date('d M Y H:i:s');
                $template->content = $request->content;
                $template->save();
            }

            return back()->with('success', 'Mail Sent Successfully!.');
        }
    }
}
