<?php

namespace App\Http\Controllers;

use App\Models\CampaignContact;
use Illuminate\Http\Request;

class CampaignContactController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $contact = new CampaignContact;
        if($request->list_id != ''){
            $contact->list_id = $request->list_id;
        }
        $contact->name = $request->name;
        $contact->email = $request->email;
        $contact->phone = $request->phone;
        $contact->user_id = auth()->user()->id;

        $prevCnt = CampaignContact::whereEmail($request->email)->where('status', '!=', 1)->first();
        if($prevCnt){
            if($prevCnt->status != 1) {
                $contact->status = $prevCnt->status;
            }
        }
        $contact->save();
        if($contact->save()) {
            Alert('success', 'Contact Created Successfully!..');
            return back();            
        } else{
            Alert('danger', 'Something Went Wrong.');
            return back();
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\CampaignContact  $campaignContact
     * @return \Illuminate\Http\Response
     */
    public function show(CampaignContact $campaignContact)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\CampaignContact  $campaignContact
     * @return \Illuminate\Http\Response
     */
    public function edit(CampaignContact $campaignContact)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\CampaignContact  $campaignContact
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, CampaignContact $campaignContact)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\CampaignContact  $campaignContact
     * @return \Illuminate\Http\Response
     */
    public function destroy(CampaignContact $campaignContact)
    {
        //
    }
}
