<?php

namespace App\Http\Controllers;

use Carbon\Carbon;
use App\Models\Consultant;
use Illuminate\Http\Request;
use App\Models\ConsultantCall;

class BenchsalesManagerDashboard extends Controller
{
    public function dashboard()
    {
        $uuids = userUserIds();

        $date = Carbon::now();
        $today = $date->copy()->today();
        $weeks = [$date->copy()->startOfWeek()->format('Y-m-d'), $date->copy()->endOfWeek()->format('Y-m-d')];
        $months = [$date->copy()->startOfMonth()->format('Y-m-d'), $date->copy()->endOfMonth()->format('Y-m-d')];
        
        /* New Queries */
        $all['total'] = Consultant::whereIn('created_by', $uuids)->count();
        $all['today'] = Consultant::whereIn('created_by', $uuids)->orWhereIn('tech_recruiter_id', $uuids)->whereDate('created_at', $today)->count();

        /* Enquiry */
        $enquiry['today'] = Consultant::whereIn('created_by', $uuids)->whereDate('created_at', $today)->whereStatus('enquiry')->count();
        
        /* Prospects */
        $prospects['today'] = Consultant::whereIn('created_by', $uuids)->whereDate('created_at', $today)->whereStatus('prospects')->count();

        /* In Training */
        $inTraining['today'] = Consultant::whereIn('created_by', $uuids)->whereDate('created_at', $today)->whereStatus('in_training')->count();
        
        /* On Bench */
        $onBench['today'] = Consultant::whereIn('created_by', $uuids)->whereDate('created_at', $today)->whereIn('status', ['on_bench', 'open_bench'])->count();
        
        /* In Job */
        $inJob['today'] = Consultant::whereIn('created_by', $uuids)->whereDate('created_at', $today)->whereStatus('in_job')->count();

        /* Dropped */
        $dropped['today'] = Consultant::whereIn('created_by', $uuids)->whereDate('created_at', $today)->whereStatus('dropped')->count();
        
        /* Technical Screening */
            $technicalScreen['total'] = 0;
            $technicalScreen['today'] =0;
            $technicalScreen['week'] = 0;
            $technicalScreen['month'] = 0;
        
        /* Visa Status */
            $f1 = 0;
            $visas = config('custom.visa_statuses');
        
        /* My Bench */
            $myBench = 0;
        
        /* Open Bench */
        $openBench['today'] = Consultant::whereIn('created_by', $uuids)->whereDate('created_at', $today)->whereStatus('open_bench')->count();
        
        /* Vendor Submissions */
            $vendorSubmissions['total'] = 0;
            $vendorSubmissions['today'] = 0;
            $vendorSubmissions['week'] = 0;
            $vendorSubmissions['month'] = 0;
        
        /* Client Interviews */
            $clientInterviews['total'] = 0;
            $clientInterviews['today'] = 0;
            $clientInterviews['week'] = 0;
            $clientInterviews['month'] = 0;
            
        /* Consultant Summary */
            $consultantSummary['total'] = 0;
            $consultantSummary['today'] = 0;
            $consultantSummary['week'] = 0;
            $consultantSummary['month'] = 0;

        /* PO Counts */
            $poStatus['total'] = 0;
            $poStatus['today'] = 0;
            $poStatus['week'] = 0;
            $poStatus['month'] = 0;

        /* Applied Jobs */
            $joinedJobs['total'] = 0;
            $joinedJobs['today'] = 0;
            $joinedJobs['week'] = 0;
            $joinedJobs['month'] = 0;

        $types = ['total'=>'All', 'today'=>'Today', 'week'=>'Week', 'month'=>'Month'];

        /* Graph Data */
            $consultant_graph_count = [];
            $months = config('custom.months_names');

            foreach($months as $k=>$val){
                $count = Consultant::whereMonth('created_at', $k)->whereYear('created_at', date('Y'))->where('created_by', auth()->user()->id)->count();

                $consultant_graph_count[] = array('month'=>date('Y-'.$k),'count'=>$count);
            }

            $consultant_graph_count = json_encode($consultant_graph_count);
        /* End Graph */
        // dd($consultant_graph_count);

        // Latest Activities
        $latest_activities = [];
        $clients = [];
        $leads = ConsultantCall::with(['consultant'])->where('status', 'call_me_later')->where('call_by', auth()->user()->id)->whereCall_status(0)->limit(5)->get();
        $submissions = [];
        $vendor_statuses = config('custom.vendor_statuses');
        $consultants = Consultant::with(['technologies'])->whereIn('created_by', $uuids)->latest()->limit(5)->get();
        $technologies = technologySelect();
        $statuses = config('custom.employee_statuses');
        $call_statuses = config('custom.call_statuses');
        $sts = null;
        return view('dashboards.benchsales', compact('all', 'enquiry', 'prospects', 'inTraining', 'technicalScreen', 'onBench', 'openBench', 'inJob', 'dropped', 'f1', 'visas', 'myBench', 'vendorSubmissions', 'clientInterviews', 'consultantSummary', 'poStatus', 'joinedJobs', 'types', 'consultant_graph_count', 'latest_activities', 'clients', 'leads', 'submissions', 'vendor_statuses', 'sts', 'consultants', 'statuses', 'call_statuses', 'technologies'));
    }
}
