<?php

namespace App\Http\Controllers;

use App\Models\Batch;
use Illuminate\Http\Request;
use App\Models\BatchTechnology;
use Illuminate\Support\Facades\DB;
use RealRashid\SweetAlert\Facades\Alert;

class BatchController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $batches = Batch::with(['trainer', 'btechnologies'])->get();
        $technologies = technologySelect();

        return view('batch.index', compact('batches', 'technologies'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $technologies = technologySelect();
        $trainers = roleUserSelect(['trainer']);
        
        return view('batch.create', compact('technologies','trainers'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        // Start transaction
        DB::beginTransaction();

        /* Store Batch */
        $batch = new Batch;
        $batch->batch_id = $request->batch_id;
        $batch->name = $request->name;
        $batch->start_date = $request->start_date;
        $batch->end_date = $request->end_date;
        $batch->trainer_id = $request->trainer_id;
        $batch->status = $request->status;
        $batch->save();

        if(isset($request->technologies) && count($request->technologies) > 0) {
            foreach ($request->technologies as $tech) {
                if($tech != null) {
                    $btech = new BatchTechnology;
                    $btech->batch_id = $batch->id;
                    $btech->technology_id = $tech;
                    $btech->save();
                }
            }
        }
        // Commit
        \DB::commit();

        Alert('success', 'Batch created successfully');
        return back();
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Batch  $batch
     * @return \Illuminate\Http\Response
     */
    public function show(Batch $batch)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Batch  $batch
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $data['batch'] = Batch::find($id);
        $data['technologies'] = technologySelect();
        $data['trainers'] = roleUserSelect(['trainer']);
        $data['btechnologies'] = batchTechnology::whereBatch_id($id)->pluck('technology_id')->all();
        
        return view('batch.edit', $data);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Batch  $batch
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        // Start transaction
        DB::beginTransaction();

        /* Store Batch */
        $batch = Batch::find($id);
        $batch->batch_id = $request->batch_id;
        $batch->name = $request->name;
        $batch->start_date = $request->start_date;
        $batch->end_date = $request->end_date;
        $batch->trainer_id = $request->trainer_id;
        $batch->status = $request->status;
        $batch->save();

        if(isset($request->technologies) && count($request->technologies) > 0) {
            $ba = BatchTechnology::where('batch_id', $id)->delete();
            
            foreach ($request->technologies as $tech) {
                if($tech != null) {
                    $btech = new BatchTechnology;
                    $btech->batch_id = $id;
                    $btech->technology_id = $tech;
                    $btech->save();
                }
            }
        }

        // Commit
        DB::commit();
        Alert('success', 'Batch updated successfully.');
        return back();
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Batch  $batch
     * @return \Illuminate\Http\Response
     */
    public function destroy(Batch $batch)
    {
        //
    }
}
