<?php

namespace App\Http\Controllers;

use App\Models\Consultant;
use Illuminate\Http\Request;

class AssignConsultantController extends Controller
{
    public function assignConsultants()
    {
        $myId = auth()->user()->id;

        if(isAdmin()) {
            $users = userSelect();

            return view('consultants.assign.create', compact('users'));
        }

        $consultants = Consultant::whereCreated_by($myId)->pluck('name', 'id')->all();
        $users = userSelect();

        return view('consultants.assign.single', compact('consultants', 'users'));
    }

    public function getConsultants(Request $request)
    {
        if($request->cids != '') {
            $cds = explode(',', $request->cids);
        } else {
            return 0;
        }

        $list = Consultant::with(['creater'])->whereIn('id', $cds)->get();
        $statuses = config('custom.employee_statuses');
        return view('consultants.assign.single-data', compact('list', 'statuses'));
    }

    public function saveAssignConsultants(Request $request)
    {
        $myId = auth()->user()->id;

        if($request->check_all == 0) {
            if($request->consultant_ids != '') {
                $cds = explode(',', $request->consultant_ids);
            } else {
                Alert('danger', 'Consultants not found');
                return back();
            }

            Consultant::whereIn('id', $cds)->update(['created_by'=>$request->user_id]);
        }
        
        if($request->check_all == 1) {
            Consultant::whereCreated_by($myId)->update(['created_by'=>$request->user_id]);
        }

        Alert('success', 'Consultants assigned successfully');
        return redirect('/assign_consultants');
    }
}
