<?php

namespace App\Http\Controllers;

use App\Models\Consultant;
use Illuminate\Http\Request;

class AgingController extends Controller
{
    public function aging()
    {
        $myId = auth()->user()->id;

        if(isAdmin()) {
            $list = Consultant::with(['ages'])->latest()->get();
        }

        if(isOpt()) {
            $list = Consultant::with(['ages'])->whereCreated_by($myId)->latest()->get();
        }

        if(isBenchsales()) {
            $list = Consultant::with(['ages'])->whereCreated_by($myId)->orWhere('tech_recruiter_id', $myId)->latest()->get();
        }

        $statuses = config('custom.employee_statuses');
        
        return view('consultants.aging.index', compact('list', 'statuses'));
    }
}
