<?php

namespace App\Http\Controllers;

use Carbon\Carbon;
use App\Models\Consultant;
use Illuminate\Http\Request;
use App\Models\ConsultantCall;

class AdminDashboard extends Controller
{
    public function dashboard()
    {
        $uuids = [];

        $date = Carbon::now();
        $today = $date->copy()->today();
        $weeks = [$date->copy()->startOfWeek()->format('Y-m-d'), $date->copy()->endOfWeek()->format('Y-m-d')];
        $months = [$date->copy()->startOfMonth()->format('Y-m-d'), $date->copy()->endOfMonth()->format('Y-m-d')];
        
        /* New Queries */
            $all['total'] = Consultant::count();
            $all['today'] = Consultant::whereDate('created_at', $today)->count();
            $all['week'] = Consultant::whereBetween('created_at', $weeks)->count();
            $all['month'] = Consultant::whereBetween('created_at', $months)->count();

        /* Enquiry */
            $enquiry['total'] = Consultant::whereStatus('enquiry')->count();
            $enquiry['today'] = Consultant::whereDate('created_at', $today)->whereStatus('enquiry')->count();
            $enquiry['week'] = Consultant::whereBetween('created_at', $weeks)->whereStatus('enquiry')->count();
            $enquiry['month'] = Consultant::whereBetween('created_at', $months)->whereStatus('enquiry')->count();
        
        /* Prospects */
            $prospects['total'] = Consultant::whereStatus('prospects')->count();
            $prospects['today'] = Consultant::whereDate('created_at', $today)->whereStatus('prospects')->count();
            $prospects['week'] = Consultant::whereBetween('created_at', $weeks)->whereStatus('prospects')->count();
            $prospects['month'] = Consultant::whereBetween('created_at', $months)->whereStatus('prospects')->count();

        /* In Training */
            $inTraining['total'] = Consultant::whereStatus('in_training')->count();
            $inTraining['today'] = Consultant::whereDate('created_at', $today)->whereStatus('in_training')->count();
            $inTraining['week'] = Consultant::whereBetween('created_at', $weeks)->whereStatus('in_training')->count();
            $inTraining['month'] = Consultant::whereBetween('created_at', $months)->whereStatus('in_training')->count();
        
        /* On Bench */
            $onBench['total'] = Consultant::whereIn('status', ['on_bench', 'open_bench'])->count();
            $onBench['today'] = Consultant::whereDate('created_at', $today)->whereIn('status', ['on_bench', 'open_bench'])->count();
            $onBench['week'] = Consultant::whereBetween('created_at', $weeks)->whereIn('status', ['on_bench', 'open_bench'])->count();
            $onBench['month'] = Consultant::whereBetween('created_at', $months)->whereIn('status', ['on_bench', 'open_bench'])->count();
        
        /* In Job */
            $inJob['total'] = Consultant::whereStatus('in_job')->count();
            $inJob['today'] = Consultant::whereDate('created_at', $today)->whereStatus('in_job')->count();
            $inJob['week'] = Consultant::whereBetween('created_at', $weeks)->whereStatus('in_job')->count();
            $inJob['month'] = Consultant::whereBetween('created_at', $months)->whereStatus('in_job')->count();

        /* Dropped */
            $dropped['total'] = Consultant::whereStatus('dropped')->count();
            $dropped['today'] = Consultant::whereDate('created_at', $today)->whereStatus('dropped')->count();
            $dropped['week'] = Consultant::whereBetween('created_at', $weeks)->whereStatus('dropped')->count();
            $dropped['month'] = Consultant::whereBetween('created_at', $months)->whereStatus('dropped')->count();
        
        /* Technical Screening */
            $technicalScreen['total'] = 0;
            $technicalScreen['today'] =0;
            $technicalScreen['week'] = 0;
            $technicalScreen['month'] = 0;
        
        /* Visa Status */
            $f1 = 0;
            $visas = config('custom.visa_statuses');
        
        /* My Bench */
            $myBench = 0;
        
        /* Open Bench */
            $openBench['total'] = Consultant::whereStatus('open_bench')->count();
            $openBench['today'] = Consultant::whereDate('created_at', $today)->whereStatus('open_bench')->count();
            $openBench['week'] = Consultant::whereBetween('created_at', $weeks)->whereStatus('open_bench')->count();
            $openBench['month'] = Consultant::whereBetween('created_at', $months)->whereStatus('open_bench')->count();
        
        /* Vendor Submissions */
            $vendorSubmissions['total'] = 0;
            $vendorSubmissions['today'] = 0;
            $vendorSubmissions['week'] = 0;
            $vendorSubmissions['month'] = 0;
        
        /* Client Interviews */
            $clientInterviews['total'] = 0;
            $clientInterviews['today'] = 0;
            $clientInterviews['week'] = 0;
            $clientInterviews['month'] = 0;
            
        /* Consultant Summary */
            $consultantSummary['total'] = 0;
            $consultantSummary['today'] = 0;
            $consultantSummary['week'] = 0;
            $consultantSummary['month'] = 0;

        /* PO Counts */
            $poStatus['total'] = 0;
            $poStatus['today'] = 0;
            $poStatus['week'] = 0;
            $poStatus['month'] = 0;

        /* Applied Jobs */
            $joinedJobs['total'] = 0;
            $joinedJobs['today'] = 0;
            $joinedJobs['week'] = 0;
            $joinedJobs['month'] = 0;

        $types = ['total'=>'All', 'today'=>'Today', 'week'=>'Week', 'month'=>'Month'];

        /* Graph Data */
            $consultant_graph_count = [];
            $months = config('custom.months_names');

            foreach($months as $k=>$val){
                $count = Consultant::whereMonth('created_at', $k)->whereYear('created_at', date('Y'))->where('created_by', auth()->user()->id)->count();

                $consultant_graph_count[] = array('month'=>date('Y-'.$k),'count'=>$count);
            }

            $consultant_graph_count = json_encode($consultant_graph_count);
        /* End Graph */
        // dd($consultant_graph_count);

        // Latest Activities
        $latest_activities = [];
        $clients = [];
        $leads = ConsultantCall::with(['consultant'])->where('status', 'call_me_later')->where('call_by', auth()->user()->id)->whereCall_status(0)->limit(5)->get();
        $submissions = [];
        $vendor_statuses = config('custom.vendor_statuses');
        $consultants = Consultant::with(['technologies'])->latest()->limit(5)->get();
        $technologies = technologySelect();
        $statuses = config('custom.employee_statuses');
        $call_statuses = config('custom.call_statuses');
        $sts = null;
        return view('dashboards.admin', compact('all', 'enquiry', 'prospects', 'inTraining', 'technicalScreen', 'onBench', 'openBench', 'inJob', 'dropped', 'f1', 'visas', 'myBench', 'vendorSubmissions', 'clientInterviews', 'consultantSummary', 'poStatus', 'joinedJobs', 'types', 'consultant_graph_count', 'latest_activities', 'clients', 'leads', 'submissions', 'vendor_statuses', 'sts', 'consultants', 'statuses', 'call_statuses', 'technologies'));
    }
}
