<?php

namespace App\Http\Controllers\Accounts\Settings;

use App\Traits\Uploads;
use App\Traits\DateTime;
use App\Utilities\Modules;
use App\Utilities\Installer;
use App\Http\Requests\Setting\Setting as Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Session;
use App\Models\Accounts\Banking\Account;
use App\Models\Accounts\Company\Company;
use App\Models\Accounts\Setting\Setting;
use App\Models\Accounts\Setting\Currency;

class Settings extends Controller
{
    use DateTime, Uploads;

    /**
     * Show the form for editing the specified resource.
     *
     * @return Response
     */
    public function edit()
    {
        /*$setting = Setting::all()->pluck('value', 'key');*/
        $setting = Setting::all()->map(function ($s) {
            $s->key = str_replace('general.', '', $s->key);
            return $s;
        })->pluck('value', 'key');

        $company_logo = $setting->pull('company_logo');

        //$setting['company_logo'] = Userdefined::getLogo();

        $invoice_logo = $setting->pull('invoice_logo');

        //$setting['invoice_logo'] = Userdefined::getLogo();

        $timezones = $this->getTimezones();

        $accounts = Account::whereEnabled(1)->get()->pluck('name_number', 'id');

        $currencies = Currency::whereEnabled(1)->pluck('name', 'code');

        $payment_methods = Modules::getPaymentMethods();

        $date_formats = [
            'd M Y' => '31 Dec '.date('Y'),
            'd m Y' => '31 12 '.date('Y'),
            'm d Y' => '12 31 '.date('Y'),
            'Y m d' => date('Y').' 12 31'
        ];

        $date_separators = [
            'dash' => trans('settings.localisation.date.dash'),
            'slash' => trans('settings.localisation.date.slash'),
            'dot' => trans('settings.localisation.date.dot'),
            'comma' => trans('settings.localisation.date.comma'),
            'space' => trans('settings.localisation.date.space'),
        ];

        $email_protocols = [
            'mail' => trans('settings.email.php'),
            'smtp' => trans('settings.email.smtp.name'),
            'sendmail' => trans('settings.email.sendmail'),
            'log' => trans('settings.email.log')
        ];

        return view('accounts.settings.settings.edit', compact(
            'setting',
            'timezones',
            'accounts',
            'currencies',
            'payment_methods',
            'date_formats',
            'date_separators',
            'email_protocols'
        ));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  Request  $request
     *
     * @return Response
     */
    public function update(Request $request)
    {
        $fields = $request->all();
        // dd($fields);
        $company_id = $request->get('company_id');

        if (empty($company_id)) {
            $company_id = session('company_id');
        }

        $company = Company::find($company_id);

        $skip_keys = ['company_id', '_method', '_token'];
        $file_keys = ['company_logo', 'invoice_logo'];

        $companies = Company::all()->count();
        
        foreach ($fields as $key => $value) {
            // Don't process unwanted keys
            if (in_array($key, $skip_keys)) {
                continue;
            }

            // Process file uploads
            if (in_array($key, $file_keys)) {
                // Upload attachment
                if ($request->file($key)) {
                    $media = $this->getMedia($request->file($key), 'settings');

                    $company->attachMedia($media, $key);

                    $value = $media->id;
                }

                // Prevent reset
                if (empty($value)) {
                    continue;
                }
            }

            // Change default locale if only 1 company
            if (($key == 'default_locale') && ($companies ==  $company_id)) {
                // Update .env file
                Installer::updateEnv([
                    'APP_LOCALE'    =>  $value
                ]);
            }

            setting()->set('general.' . $key, $value);

        }
            // Save all settings
            setting()->save();

        $message = trans('messages.success.updated', ['type' => trans_choice('general.settings', 2)]);

        Session::flash('success',$message);

        return redirect('settings/ac_settings');
    }
}
