<?php

namespace App\Http\Controllers\Accounts\Runpayrole;

use DateTime;
use DateInterval;
use App\Models\TimeSheet;
use App\Models\Consultant;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Session;
use App\Models\Accounts\Income\Customer;
use App\Models\Employee\EmployeePayrate;
use App\Models\Vendor as EmployeeVendor;
use App\Models\Timesheets\TimesheetWeekly;
use App\Models\Timesheets\TimesheetWeeklyTotal;
use App\Models\Accounts\Runpayrole\PayroleModel;

class Payrole extends Controller
{
    public function index()
    {
      $curl_handle=curl_init();
      curl_setopt($curl_handle,CURLOPT_URL,'https://adpapi.adp.com/events/hr/v1/worker.legal-address.add');
      curl_setopt($curl_handle,CURLOPT_CONNECTTIMEOUT,2);
      curl_setopt($curl_handle,CURLOPT_RETURNTRANSFER,1);
      $buffer = curl_exec($curl_handle);
      curl_close($curl_handle);
      if (empty($buffer)){
          print "Nothing returned from url.<p>";
      }
      else{
          print $buffer;
      }
      die;
       $payroles = PayroleModel::with(['user'])->collect();



      return view('accounts.payrole.enterpayrole.index',compact('payroles'));
    }


    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {            
        $employees = Consultant::where('status','in_job')->pluck('name', 'id')->all();

        return view('accounts.payrole.enterpayrole.create',compact('employees'));
    }
 
    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $date = $this->date_format_change_unique($request->paydate);
        $request['paydate'] =  date("Y-m-d", strtotime($date[0]));
        PayroleModel::create($request->all());

        $message = trans('messages.success.added', ['type' => trans('payrole.payrole')]);

        Session::flash('success', $message);

        return redirect('payrole/payrole');
    }
 
    /**
     * Display the specified resource.
     *
     * @param  \App\Employee  $employee
     * @return \Illuminate\Http\Response
     */
    public function show()
    {
        //
    }
 
    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Employee  $employee
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $employees = Consultant::where('status','in_job')->pluck('name','id')->all();
        $payrole  = PayroleModel::find($id);

        return view('accounts.payrole.enterpayrole.edit',compact('payrole','employees'));
    }
 
    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Employee  $employee
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request)
    {   
        
        $payrole  = PayroleModel::find($request->payrole_id);
        $date = $this->date_format_change_unique($request->paydate);
        $request['paydate'] =  date("Y-m-d", strtotime($date[0]));
        $payrole->update($request->all());

        $message = trans('messages.success.updated', ['type' => trans('payrole.payrole')]);

        Session::flash('success', $message);
        
        return redirect('payrole/payrole');
    }
 
    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Employee  $employee
     * @return \Illuminate\Http\Response
     */
    public function destroy(PayroleModel $payrole)
    {
        $payrole->delete();
         $message = trans('messages.warning.deleted', ['name' => $account->name, 'text' => implode(', ', $relationships)]);

            Session::flash('warning',$message);

        return redirect('payrole/payrole');
    }


    public function timesheet(){

        $customers = Customer::where('timesheet','=','1')->pluck('name','consultant');

        $date = new \DateTime();

        $month = $date->format("n");

        $year =  $date->format("Y");

        $week = $date->format("W");

        $results = TimeSheet::employees_weekly_data_customer($year,$week,2,null);

    	return view('accounts.payrole.timesheet.index',compact('customers','results'));
    }

    public function timesheet_create()
    {
        $customers = Customer::where('timesheet','=','1')->pluck('name', 'consultant');
        
        return view('accounts.payrole.timesheet.create',compact('customers'));
    }

    public function timesheet_edit($id)
    {
        $timesheet =  TimesheetWeekly::find($id);
        
        $customers = Customer::where('timesheet','=','1')->pluck('name','consultant');

        return view('accounts.payrole.timesheet.edit',compact('timesheet','customers'));
    }

    public function timesheet_approve()
    {
        return TimesheetWeekly::where('id',request('timesheet_weekly_id'))->update(['approved_status' => request('status')]);
    }


    public function timecard($customer_id)
    {
        $customer = Customer::find($customer_id)->consultant;
        
        if($customer){
            //$date = new \DateTime();
            //$month = $date->format('m');
            //$year  = $date->format('Y');
            //$weeks = Helper::weeks('01',$month,$year);

            return TimeSheet::yearly_sheets_single($customer);

            //return TimesheetWeekly::where('emp_id',$customer)->whereIn('week_value',$weeks)->where('year_value',$year)->orderBy('week_value','desc')->get();
        }
    }


    public function timesheetdetails($employee_id)
    {
        $value = explode('-',$employee_id);
        if(count($value) > 1){
            $employee_id = $value[0];
            $person_type = $value[1];
        }else{
            $employee_id = $employee_id; 
            $person_type = 'consultant';
        }
       


        $date = new \DateTime;
        $year = date('Y');
        $year_data = [];
        for ($i=1; $i <= 12; $i++) { 
          $weeksinmonth = $this->getWeeksInMonth($year,$i,'6');
          $year_data[$i] = TimesheetWeekly::where('emp_id',$employee_id)->whereIn('week_value',array_keys($weeksinmonth))->where('approved_status','=','1')->where('person_type',$person_type)->where('year_value',$year)->orderBy('week_value','desc')->get();
        }

        return $year_data;  
    }

    public function getWeeksInMonth($year, $month, $lastDayOfWeek)
    {

        $aWeeksOfMonth = [];
        $date = new DateTime("{$year}-{$month}-01");
        $iDaysInMonth = cal_days_in_month(CAL_GREGORIAN, $month, $year);
        $aOneWeek = [$date->format('Y-m-d')];
        $weekNumber = 1;
        for ($i = 1; $i <= $iDaysInMonth; $i++)
        {
            if ($lastDayOfWeek == $date->format('N') || $i == $iDaysInMonth)
            {
                $aOneWeek[]      = $date->format('Y-m-d');
                $weeks     = $date->format('W');
                $aWeeksOfMonth[$weeks] = $aOneWeek;
                $date->add(new DateInterval('P1D'));
                $aOneWeek = [$date->format('Y-m-d')];
                $i++;

            }
            $date->add(new DateInterval('P1D'));
        }
        return $aWeeksOfMonth;
    }

    public function show_timesheet_weekly_data(Request $request)
    {
        $week = $request->week;
        $year = $request->year;

        $employee_id = isset($request->employee_id)?$request->employee_id:null;

        $results = TimeSheet::employees_weekly_data_customer($year,$week,2,$employee_id);
        
        return view('accounts.payrole.timesheet.show',compact('results'));
    }

    public function approvetimesheet(Request $request)
    { 
        $skipkeys = ['_token','item_id'];
        $quantity  = 0;
        foreach($request->approvetimesheet as $key => $value){            
            if(in_array($value, $skipkeys)){
                continue;
            }
            $timesheet = explode("_",$value);
            $timesheet_object = TimesheetWeekly::where('id',$timesheet[1])->update(["approved_days->$timesheet[0]"=>'approved']);
            $quantity  += $request->total_hours[$key];
        }

        return response()->json(['quantity' => $quantity,'item_id' => $request->item_id]);
    }


    public function getpayrate($id)
    {
        $employee_payrates = EmployeePayrate::where('employee_id',$id)->where('status','0')->first();

        $employee_vendor   = EmployeeVendor::find($employee_payrates->vendor_id);
    
        $startDate =   strtotime(explode('-', request('date'))[0]);
        $endDate   =   strtotime(explode('-', request('date'))[1]);

        $currentDate = $startDate;
        $employee_hours = 0;
       // $weekNumbers = array();
        while ($currentDate < $endDate) {
          //  $weekNumbers[] = date('d-m-Y', $currentDate);
            $year = date('Y',$currentDate);
            $month = date('m',$currentDate);
            $day = date('d',$currentDate);

            $hours = TimesheetWeeklyTotal::where('employee_id',$id)->where('year_value',$year)->where('month_value',$month)->first();

            if(!empty($hours)){
                $week = $this->weekOfMonth($year,$month,$day);
                $employee_hours += $hours->$week;
               
            }
            $currentDate = strtotime('+1 week', $currentDate);
        }

       return json_encode(['employee_payrates'=>$employee_payrates,'employee_vendor'=>$employee_vendor,'employee_hours'=>$employee_hours]);
    }

    public function weekOfMonth($y,$m,$d){

        $w = 1;
        for ($i = 1; $i <= $d; ++$i) {
            if ($i > 1 && date('w', strtotime("$y-$m-$i")) == 0) {
                ++$w;
            }
        }
        return 'week'.$w;
    }
}
