<?php

namespace App\Http\Controllers\Accounts\Items;

use App\Traits\Uploads;
use Illuminate\Http\Request;
use App\Utilities\ImportFile;
use App\Models\Accounts\Item\Item;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Session;
use App\Models\Accounts\Setting\Category;
use App\Models\Accounts\Setting\Currency;
use App\Models\Accounts\Accounting\Chartofaccounts;

class ItemController extends Controller
{
    use Uploads;

    /**
     * Display a listing of the resource.
     *
     * @return Response
     */
    public function index()
    {
        $elements = Item::get()->toArray();
        
        $categories = Category::enabled()->type('item')->pluck('name', 'id')
            ->prepend(trans('general.all_type', ['type' => trans_choice('general.categories', 2)]), '');

        $page = isset(request()->page)?request()->page:1;

        $items =  app('App\Http\Controllers\Accounts\Incomes\Customers')->paginate($this->bulidItems($elements),$perPage = 25, $page,['path' => 'items']);        

        return view('accounts.items.items.index', compact('items', 'categories'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return Response
     */
    public function create()
    {
        //$categories = Category::enabled()->type('item')->pluck('name', 'id');

        $productservice = array('0'=>'Inventory','1'=>'Non-Inventory','2'=>'Service','3'=>'Bundle');

        $income_account = Chartofaccounts::get()->pluck('name','id');
        
        $elements = Item::select('id','name','subitem')->get()->toArray();

        $items  = $this->bulidItems($elements);

        
      return view('accounts.items.items.create', compact('productservice','income_account','items'));
    }


    function bulidItems(array $elements, $parentId = NULL) {
            $child = array();
        
            foreach ($elements as $element) {
                if ($element['subitem'] == $parentId) {

                    $children = $this->bulidItems($elements, $element['id']);

                        if (!empty($children) > 0 ) {
                            $element['children'] = $children;
                        }

                    $child[] = $element;
                }
            }
        return $child;
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  Request  $request
     *
     * @return Response
     */
    public function store(Request $request)
    {           
        $request['income_account'] = $request->income_account;
           // $request['expense_account'] = $request->expense_account;
            /*}else{
                $request['income_account'] = $request->income_account_non_inventory;
                $request['expense_account'] = $request->expense_account_non_inventory;
            }*/

        $item = Item::create($request->input());

        // Upload picture
        if ($request->file('picture')) {
            $media = $this->getMedia($request->file('picture'), 'items');

            $item->attachMedia($media, 'picture');
        }

        $message = trans('messages.success.added', ['type' => trans_choice('general.items', 1)]);

        Session::flash('success',$message);

        return redirect('items/items');
    }

    /**
     * Import the specified resource.
     *
     * @param  ImportFile  $import
     *
     * @return Response
     */
    public function import(ImportFile $import)
    {

        $rows = $import->all();

        foreach ($rows as $row) {
            $data = $row->toArray();

            $item_name =  explode(':',$row['item']);
            if(count($item_name) > 1){
                $name = $item_name[count($item_name)-1];
                $parent_id = Item::where('name' , 'like', '%'. $item_name[count($item_name)-2])->first()->id;
            }else{
                $name = $item_name[0]; 
                $parent_id = ''; 
            }
            $data['company_id'] = session('company_id');
            $chart_id =  Chartofaccounts::where( 'name', 'like', '%' . $row->account . '%')->first();
            if($chart_id){
                $income_account =  $chart_id->id;
            }else{
                $chartofaccount = new Chartofaccounts;
                $chartofaccount->name =  $row->account;
                $chartofaccount->company_id = session('company_id');
                $chartofaccount->account_type_id = '15';
                $chartofaccount->detail_type = '126';
                $chartofaccount->enabled = '1';
                $chartofaccount->currency_code = 'USD';
                $chartofaccount->save();
                $income_account =  $chartofaccount->id;
            }
           
            switch ($row->type) {
                case 'Service':
                    $source_type = '2';
                    break;
                case 'Inventory':
                    $source_type = '0';
                    break;
                case 'Non-Inventory':
                    $source_type = '1';
                    break;
                case 'Bundle':
                    $source_type = '3';
                    break;
                default:
                    $source_type = '2';
                break;
            }
            switch ($row->active_status) {
                case 'Active':
                   $enabled = '1';
                break;
                case 'In-Active':
                  $enabled = '0';
                break;
                default:
                    $enabled = '1';
                break;
            }
            $data['source_type'] = $source_type;
            $data['name'] = $name;
            $data['sales_information'] = $row->description;
            $data['sale_price'] = $row->price;
            $data['purchase_price'] = $row->price;
            $data['income_account'] = $income_account;
            $data['enabled'] = $enabled;
            $data['subitem'] = $parent_id;
            Item::create($data);
        }
        $message = trans('messages.success.imported', ['type' => trans_choice('general.items', 2)]);

        Session::flash('success',$message);

        return redirect('items/items');
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  Item  $item
     *
     * @return Response
     */
    public function edit(Item $item)
    {
        $income_account = Chartofaccounts::pluck('name','id');
        $product_serve =  array('0'=>'Inventory','1'=>'Non-Inventory','2'=>'Service','3'=>'Bundle');

        $elements = Item::select('id','name','subitem')->get()->toArray();

        $items  = $this->bulidItems($elements);

       return view('accounts.items.items.edit', compact('items','item','income_account','product_serve'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  Item  $item
     * @param  Request  $request
     *
     * @return Response
     */
    public function update(Item $item, Request $request)
    {
        $request['income_account'] = $request->income_account;

        $item->update($request->input());

        // Upload picture
        if ($request->file('picture')) {
            $media = $this->getMedia($request->file('picture'), 'items');

            $item->attachMedia($media, 'picture');
        }

        $message = trans('messages.success.updated', ['type' => trans_choice('general.items', 1)]);

        Session::flash('success',$message);

        return redirect('items/items');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  Item  $item
     *
     * @return Response
     */
    public function destroy(Item $item)
    {
        $relationships = $this->countRelationships($item, [
            'invoice_items' => 'invoices',
            'bill_items' => 'bills',
        ]);

        if (empty($relationships)) {
            $item->delete();

            $message = trans('messages.success.deleted', ['type' => trans_choice('general.items', 1)]);

            Session::flash('success',$message);
        } else {
            $message = trans('messages.warning.deleted', ['name' => $item->name, 'text' => implode(', ', $relationships)]);

            Session::flash('warning',$message);
        }

        return redirect('items/items');
    }

    public function totalDeposite(){
        $input_items = request('item');

        $json = new \stdClass;

        $sub_total = 0;

        $items = array();

        if ($input_items) {
            foreach ($input_items as $key => $item) {
                $price = (double) $item['price'];
                $quantity = (int) 1;

                
                $item_sub_total = ($price * $quantity);

               

                $sub_total += $item_sub_total;

                $total = $item_sub_total;

                $items[$key] = money($total, 'USD', true)->format();
            }
        }

        $json->items = $items;

        $json->sub_total = money($sub_total,'USD', true)->format();

     

        $grand_total = $sub_total ;

        $json->grand_total = money($grand_total,'USD', true)->format();

        return response()->json($json);
    }

    public function autocomplete()
    {
        $type = request('type');
        $query = request('query');
        $currency_code = request('currency_code');

        if (empty($currency_code) || (strtolower($currency_code)  == 'null')) {
            $currency_code = setting('general.default_currency');
        }

        $currency = Currency::where('code', $currency_code)->first();

        $filter_data = array(
            'name' => $query
        );

        $items = Item::getItems($filter_data);

        if ($items) {
            foreach ($items as $item) {
                $tax = Tax::find($item->tax_id);

                $item_tax_price = 0;

                if (!empty($tax)) {
                    $item_tax_price = ($item->sale_price / 100) * $tax->rate;
                }

                $item->sale_price = $this->convertPrice($item->sale_price, $currency_code, $currency->rate);
                $item->purchase_price = $this->convertPrice($item->purchase_price, $currency_code, $currency->rate);

                switch ($type) {
                    case 'bill':
                        $total = $item->purchase_price + $item_tax_price;
                        break;
                    case 'invoice':
                    default:
                        $total = $item->sale_price + $item_tax_price;
                        break;
                }

                $item->total = money($total, $currency_code, true)->format();
            }
        }

        return response()->json($items);
    }

        public function autocompletebill()
    {
        $type = request('type');
        $query = request('query');
        $currency_code = request('currency_code');

    
        if (empty($currency_code) || (strtolower($currency_code)  == 'null')) {
            $currency_code = setting('general.default_currency');
        }

        $currency = Currency::where('code', $currency_code)->first();


        $filter_data = array(
            'id' => $query
        );

        $items = Item::select('id as item_id', 'name', 'sale_price', 'purchase_price','income_account','expense_account')->find($query);

            if ($items) {               
                $items->sale_price = $this->convertPrice($items->sale_price, $currency_code, $currency->rate);
                $items->purchase_price = $this->convertPrice($items->sale_price, $currency_code, $currency->rate);

                switch ($type) {
                    case 'bill':
                        $total = $items->purchase_price;
                        break;
                    case 'invoice':
                    default:
                        $total = $items->sale_price;
                        break;
                }

                $items->total = money($total, $currency_code, true)->format();
            }

        return response()->json($items);
    }

    public function totalBillamount()
    {
        $input_items = request('item');
     
        $input_account = request('account');


        $input_items_account = array_merge($input_account);

        $currency_code = request('currency_code');

        if (empty($currency_code)) {
            $currency_code = setting('general.default_currency');
        }

        $json = new \stdClass;

        $sub_total = 0;
        $tax_total = 0;

        $items = array();
        $accounts = array();

        if ($input_items) {
            foreach ($input_items as $key => $item) {
                $price = (double) $item['price'];
                $quantity = (double) $item['quantity'];

                $item_tax_total= 0;
                $item_sub_total = ($price * $quantity);

                if (!empty($item['tax_id'])) {
                    $tax = Tax::find($item['tax_id']);

                    $item_tax_total = (($price * $quantity) / 100) * $tax->rate;
                }

                $total = $item_sub_total + $item_tax_total;

               $items[$key] = money($total, $currency_code, true)->format();
            }
        }
        if ($input_account) {
            foreach ($input_account as $key => $account) {
                $price = (double) $account['price'];
                $quantity = (double) $account['quantity'];

                $account_tax_value= 0;
                $account_sub_total = ($price * $quantity);

                if (!empty($account['tax_id'])) {
                    $tax = Tax::find($account['tax_id']);

                    $account_tax_value = (($price * $quantity) / 100) * $tax->rate;
                }

                $total = $account_sub_total + $account_tax_value;

                $accounts[$key] = money($total,$currency_code,true)->format();
            }
        }

        if ($input_items_account) {
            foreach ($input_items_account as $key => $total) {
                $price = (double) $total['price'];
                $quantity = (double) $total['quantity'];

                $total_tax_total= 0;
                $total_sub_total = ($price * $quantity);

                if (!empty($total['tax_id'])) {
                    $tax = Tax::find($total['tax_id']);

                    $total_tax_total = (($price * $quantity) / 100) * $tax->rate;
                }

                $sub_total += $total_sub_total;
                $tax_total += $total_tax_total;
            }
        } 
        
        
        $json->items = $items;    

        $json->account = $accounts;

        $json->sub_total = money($sub_total, $currency_code, true)->format();

        $json->tax_total = money($tax_total, $currency_code, true)->format();

        $grand_total = $sub_total + $tax_total;

        $json->grand_total = money($grand_total, $currency_code, true)->format();

        return response()->json($json);
    }

    public function totalChequeamount()
    {
       
     
        $input_account = request('account');


        $input_items_account = $input_account;

        $currency_code = request('currency_code');

        if (empty($currency_code)) {
            $currency_code = setting('general.default_currency');
        }

        $json = new \stdClass;

        $sub_total = 0;
        

        $items = array();
        $accounts = array();

        
        if ($input_account) {
            foreach ($input_account as $key => $account) {
                $price = (double) $account['price'];
                $quantity = (double) $account['quantity'];

                $account_tax_value= 0;
                $account_sub_total = ($price * $quantity);

                $total = $account_sub_total + $account_tax_value;

                $accounts[$key] = money($total,$currency_code,true)->format();
            }
        }

        if ($input_items_account) {
            foreach ($input_items_account as $key => $total) {
                $price = (double) $total['price'];
                $quantity = (double) $total['quantity'];

               
                $total_sub_total = ($price * $quantity);

               
                $sub_total += $total_sub_total;
                
            }
        } 
        
        
        $json->account = $accounts;

        $json->sub_total = money($sub_total, $currency_code, true)->format();

        $grand_total = $sub_total;

        $json->grand_total = money($grand_total, $currency_code, true)->format();

        return response()->json($json);
    }

    public function totalItem()
    {
        $input_items = request('item');
       
        $currency_code = request('currency_code');

        if (empty($currency_code)) {
            $currency_code = setting('general.default_currency');
        } 
        $json = new \stdClass; 
        $sub_total = 0; 
        $items = array();

        if ($input_items) {
            foreach ($input_items as $key => $item) {
                if(isset($item['price'])){ 
                    $price = (double) $item['price'];
                    $quantity = (double) $item['quantity'];
                    $item_sub_total = ($price * $quantity);
                    $sub_total += $item_sub_total;
                    $total = $item_sub_total;
                    $items[$key] = money($total, $currency_code, true)->format();
                }
            }
        } 
        $json->items = $items;

        $json->sub_total = money($sub_total, $currency_code, true)->format();

     

        $grand_total = $sub_total ;

        $json->grand_total = money($grand_total, $currency_code, true)->format();

        return response()->json($json);
    }

    protected function convertPrice($amount, $currency_code, $currency_rate, $format = false, $reverse = false)
    {
        $item = new Item();

        $item->amount = $amount;
        $item->currency_code = $currency_code;
        $item->currency_rate = $currency_rate;

        if ($reverse) {
            return $item->getReverseConvertedAmount($format);
        }

        return $item->getConvertedAmount($format);
    }
}
