<?php

namespace App\Http\Controllers\Accounts\Dashboard;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Accounts\Expense\Bill;
use App\Models\Accounts\Income\Invoice;
use App\Models\Accounts\Banking\Account;
use App\Models\Accounts\Expense\Payment;

class Totals extends Controller
{
    /**
     * Invoice Totals
     */
    public function incomeTotals(Request $request)
    {
        $dates = explode('-', $request->dates);
        $rdates = [date('Y-m-d', strtotime($dates[0])), date('Y-m-d', strtotime($dates[1]))];

        $invoices = Invoice::whereBetween('invoiced_at', $rdates);

        $total = $invoices->sum('amount');
        $opened = $invoices->where('invoice_status_code', '!=', 'paid')->sum('amount');
        $over = $invoices->where('invoice_status_code', '!=', 'paid')->whereDate('due_at', '<', date('Y-m-d'))->sum('amount');
        
        $total = money(($total != '')?$total:0, 'USD', true);
        $opened = money(($opened != '')?$opened:0, 'USD', true);
        $over = money(($over != '')?$over:0, 'USD', true);

        return ['total'=>$total, 'opened'=>$opened, 'over'=>$over];
    }

    /**
     * Expenses Totals
     */
    public function expenseTotals(Request $request)
    {
        $dates = explode('-', $request->dates);
        $rdates = [date('Y-m-d', strtotime($dates[0])), date('Y-m-d', strtotime($dates[1]))];

        $bills = Bill::whereBetween('billed_at', $rdates);

        $total = $bills->sum('amount');
        $opened = $bills->where('bill_status_code', '!=', 'paid')->sum('amount');
        $over = $bills->where('bill_status_code', '!=', 'paid')->whereDate('due_at', '<', date('Y-m-d'))->sum('amount');

        $total = money(($total != '') ? $total : 0, 'USD', true);
        $opened = money(($opened != '') ? $opened : 0, 'USD', true);
        $over = money(($over != '') ? $over : 0, 'USD', true);

        return ['total' => $total, 'opened' => $opened, 'over' => $over];
    }

    /**
     * Profits Totals = Incomes - Expenses
     */
    public function profitTotals(Request $request)
    {
        $dates = explode('-', $request->dates);
        $rdates = [date('Y-m-d', strtotime($dates[0])), date('Y-m-d', strtotime($dates[1]))];

        $invoices = Invoice::whereBetween('invoiced_at', $rdates);
        $inv_total = $invoices->sum('amount');
        $inv_opened = $invoices->where('invoice_status_code', '!=', 'paid')->sum('amount');
        $inv_over = $invoices->where('invoice_status_code', '!=', 'paid')->whereDate('due_at', '<', date('Y-m-d'))->sum('amount');

        $bills = Bill::whereBetween('billed_at', $rdates);
        $bill_total = $bills->sum('amount');
        $bill_opened = $bills->where('bill_status_code', '!=', 'paid')->sum('amount');
        $bill_over = $bills->where('bill_status_code', '!=', 'paid')->whereDate('due_at', '<', date('Y-m-d'))->sum('amount');

        $total = $inv_total - $bill_total;
        $opened = $inv_opened - $bill_opened;
        $over = $inv_over - $bill_over;

        $total = money(($total != '') ? $total : 0, 'USD', true);
        $opened = money(($opened != '') ? $opened : 0, 'USD', true);
        $over = money(($over != '') ? $over : 0, 'USD', true);

        return ['total' => $total, 'opened' => $opened, 'over' => $over];
    }

    /**
     * Accounts List
     */
    public function accountsList(Request $request)
    {
       // $dates = explode('-', $request->dates);
       // $rdates = [date('Y-m-d', strtotime($dates[0])), date('Y-m-d', strtotime($dates[1]))];

        $accounts = Account::whereEnabled(1)->get();
        $data  = '';

        foreach ($accounts as $value) {

            $data .= '<tr>';
            $data .=   '<td>'.$value->name_number.'</td>';
            $data .=    '<td>'.money($value->balance, 'USD',true).'</td>';
            $data .= '</tr>'; 
        }

        return $data;
    }

    /**
     * LATEST EXPENSES
     */
    public function latestExpenses(Request $request)
    {
        $dates = explode('-', $request->dates);
        $rdates = [date('Y-m-d', strtotime($dates[0])), date('Y-m-d', strtotime($dates[1]))];

        $bills = collect(Bill::orderBy('billed_at', 'desc')->whereBetween('billed_at', $rdates)->accrued()->take(20)->get())->each(function ($item) {
            $item->paid_at = $item->billed_at;
        });

        $payments = collect(Payment::orderBy('paid_at', 'desc')->whereBetween('paid_at', $rdates)->take(20)->get());

        $latestExps = $payments->merge($bills)->take(20)->sortByDesc('paid_at');

        return view('accounts.dashboard.listings.latest-exps', compact('latestExps'));
    }

    /**
     * LATEST INCOMES
     */
    public function latestIncomes(Request $request)
    {
        $dates = explode('-', $request->dates);
        $rdates = [date('Y-m-d', strtotime($dates[0])), date('Y-m-d', strtotime($dates[1]))];

        $invoices = collect(Invoice::orderBy('invoiced_at', 'desc')->whereBetween('invoiced_at', $rdates)->accrued()->take(20)->get())->each(function ($item) {
            $item->paid_at = $item->invoiced_at;
        });

        $latestIncomes =  $invoices->take(20)->sortByDesc('paid_at');

        return view('accounts.dashboard.listings.latest-incomes', compact('latestIncomes'));
    }
}
