<?php

namespace App\Http\Controllers\Accounts\Banking;

use App\Mail\SendHtml;
use App\Utilities\Modules;
use App\Classes\DepositType;
use Illuminate\Http\Request;
use App\Models\Accounts\Banking\Account;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Mail;
use App\Models\Accounts\Charthistory;
use App\Models\Accounts\Income\Revenue;
use Illuminate\Support\Facades\Session;
use App\Models\Accounts\Expense\Payment;
use App\Models\Accounts\Banking\Transfer;
use App\Models\Accounts\Setting\Category;
use App\Models\Accounts\Setting\Currency;
use App\Models\Accounts\CharthistoryParent;
use App\Models\Accounts\Accounting\Chartofaccounts;

class TransferController extends Controller
{
    public function index()
    {
        $request = request();  

        $items = Transfer::with(['payment', 'revenue'])->get()->collect('payment.paid_at');
        $accounts = collect(Account::whereEnabled(1)->get()->pluck('name_number', 'id'))
            ->prepend(trans('general.all_type', ['type' => trans_choice('general.accounts', 2)]), '');
           
        $transfers = array();

        foreach ($items as $item) {
            $payment = $item->payment;

            $revenue = $item->revenue;

            $transfers[] = (object)[
                'from_account' => $payment?->account?->name_number,
                'to_account' => $revenue?->account?->name_number,
                'amount' => $payment->amount,
                'currency_code' => $payment->currency_code,
                'paid_at' => $payment->paid_at,
                'id' => $item->id,
            ];
        }

        $special_key = array(
            'payment.name' => 'from_account',
            'revenue.name' => 'to_account',
        );

        if (isset($request['sort']) && array_key_exists($request['sort'], $special_key)) {
            $sort_order = array();

            foreach ($transfers as $key => $value) {
                $sort = $request['sort'];

                if (array_key_exists($request['sort'], $special_key)) {
                    $sort = $special_key[$request['sort']];
                }

                $sort_order[$key] = $value->{$sort};
            }

            $sort_type = (isset($request['order']) && $request['order'] == 'asc') ? SORT_ASC : SORT_DESC;

            array_multisort($sort_order, $sort_type, $transfers);
        }
        return view('accounts.banking.transfers.index', compact('transfers', 'items', 'accounts'));
    }

    public function create()
    {
        $accounts = Account::whereEnabled(1)->get()->pluck('name_number','id')->all();
        $payment_methods = Modules::getPaymentMethods();
        
        return view('accounts.banking.transfers.create', compact('accounts', 'payment_methods'));
    }

    public function chartId($id)
    {
        $chartof_accounts = Chartofaccounts::where('bank_id', $id)->first();
        return $chartof_accounts->id;
    }

    public function store(Request $request)
    {
        $currencies = Currency::whereEnabled(1)->pluck('rate', 'code')->all();
        $payment_currency_code = Account::where('id', $request['from_account_id'])->pluck('currency_code')->first();
        $revenue_currency_code = Account::where('id', $request['to_account_id'])->pluck('currency_code')->first();
        
        $request['account_id'] = $request['from_account_id'];
        $date = $this->date_format_change_unique($request->transferred_at);
        $request['paid_at'] = date("Y-m-d", strtotime($date[0]));
        $request['currency_code'] = $payment_currency_code;
        $request['currency_rate'] = $currencies[$payment_currency_code];
        $request['vendor_id'] = '0';
        $request['category_id'] = Category::transfer(); // Transfer Category ID
        $request['attachment'] = '';
        $request['transferred_at'] =  date("Y-m-d", strtotime($date[0])); 
        $payment = Payment::create($request->all());

        $transfer = new Transfer();
        $transfer->default_currency_code = $payment_currency_code;
        $transfer->amount = $request['amount'];
        $transfer->currency_code = $revenue_currency_code;
        $transfer->currency_rate = $currencies[$revenue_currency_code];

        $amount = $transfer->getDynamicConvertedAmount();

        $request['account_id'] = $request['to_account_id'];
        // paid_at
        $request['amount'] = $amount;
        $request['currency_code'] = $revenue_currency_code;
        $request['currency_rate'] = $currencies[$revenue_currency_code];
        $request['customer_id'] = '0';

        $revenue = Revenue::create($request->all());

        $chart_object = Chartofaccounts::find($request->from_account_chart_id);

        // Amount Remove From Account
        $chart_history = new Charthistory;
        $chart_history->company_id = 1;
        $chart_history->transaction_id = $payment->id;
        $chart_history->transaction_type = 'Transfer';
        $chart_history->currency_code = $payment_currency_code;
        $chart_history->chartofaccount_id = $request->from_account_chart_id;
        $chart_history->account_type_id = $chart_object->account_type_id;
        $chart_history->detail_type = $chart_object->detail_type;
        $chart_history->amount = $request->amount;
        $chart_history->description = $request->description;
        $chart_history->amount_type = DepositType::find($request->from_account_chart_id,'credit');
        $chart_history->transaction_date = date('Y-m-d',strtotime($date[0]));
        $chart_history->save();

        $chartparents = app('App\Http\Controllers\Accounts\Accounting\Accounting')->parent_chartaccount_id($request->from_account_chart_id);

        CharthistoryParent::charthistoryparentsave($chart_history->id,$chartparents->original['parent_id_string'],$request->from_account_chart_id);

        $chart_object = Chartofaccounts::find($request->to_account_chart_id);

        // Amount Added To Recived Account
        $chart_history = new Charthistory;
        $chart_history->company_id = 1;
        $chart_history->transaction_id = $revenue->id;
        $chart_history->transaction_type = 'Transfer';
        $chart_history->currency_code = $payment_currency_code;
        $chart_history->chartofaccount_id = $request->to_account_chart_id;
        $chart_history->account_type_id = $chart_object->account_type_id;
        $chart_history->detail_type = $chart_object->detail_type;
        $chart_history->amount = $request->amount;
        $chart_history->description = $request->description;
        $chart_history->amount_type = DepositType::find($request->to_account_chart_id,'debit');
        $chart_history->transaction_date = date('Y-m-d',strtotime($date[0]));
        $chart_history->save();
        
        $chartparents = app('App\Http\Controllers\Accounts\Accounting\Accounting')->parent_chartaccount_id($request->to_account_chart_id);

        CharthistoryParent::charthistoryparentsave($chart_history->id,$chartparents->original['parent_id_string'],$request->to_account_chart_id);

        $request['payment_id'] = $payment->id;
        $request['revenue_id'] = $revenue->id;

        Transfer::create($request->all());

        $message = trans('messages.success.added', ['type' => trans_choice('general.transfers', 1)]);
        $subject = trans('messages.success.added', ['type' => trans_choice('general.transfers', 1)]);

        Mail::to(config('configurations.mailusername'))->send(new SendHtml(auth()->user()->email,$message,$subject));

        Session::flash('success',$message);

        return redirect('banking/transfers');
    }

    public function edit(Transfer $transfer)
    {        
        $payment = Payment::findOrFail($transfer->payment_id);
        $revenue = Revenue::findOrFail($transfer->revenue_id);

        $transfer['from_account_id'] = $payment->account_id;
        $transfer['to_account_id'] = $revenue->account_id;
        $transfer['transferred_at'] = $revenue->deposited_at;
        $transfer['description'] = $revenue->description;
        $transfer['amount'] = $payment->amount;
        $transfer['payment_method'] = $revenue->payment_method;
        $transfer['reference'] = $revenue->reference;
        
        $accounts = collect(Account::whereEnabled(1)->get()->pluck('name_number', 'id'))->all();
        // dd($accounts);

        $payment_methods = Modules::getPaymentMethods();


        return view('accounts.banking.transfers.edit', compact('transfer', 'accounts', 'payment_methods'));
    }

    public function update(Transfer $transfer, Request $request)
    {
        $currencies = Currency::whereEnabled(1)->pluck('rate', 'code')->toArray();

        $payment_currency_code = Account::where('id', $request['from_account_id'])->pluck('currency_code')->first();
        $revenue_currency_code = Account::where('id', $request['to_account_id'])->pluck('currency_code')->first();

        $payment = Payment::find($transfer->payment_id);
        $request['account_id'] = $request['from_account_id'];
        $date = $this->date_format_change_unique($request->transferred_at);
        $request['paid_at'] = date("Y-m-d", strtotime($date[0]));
        $request['currency_code'] = $payment_currency_code;
        $request['currency_rate'] = $currencies[$payment_currency_code];
        $request['vendor_id'] = '0';
        $request['category_id'] = Category::transfer(); // Transfer Category ID
        $request['attachment'] = ''; 
        
        $payment->update($request->all());

        $revenue = Revenue::find($transfer->revenue_id);

        $transfer = new Transfer();

        $transfer->default_currency_code = $payment_currency_code;
        $transfer->amount = $request['amount'];
        $transfer->currency_code = $revenue_currency_code;
        $transfer->currency_rate = $currencies[$revenue_currency_code];

        $amount = $transfer->getDynamicConvertedAmount();

        $request['account_id'] = $request['to_account_id'];
        $request['amount'] = $amount;
        $request['currency_code'] = $revenue_currency_code;
        $request['currency_rate'] = $currencies[$revenue_currency_code];
        $request['customer_id'] = '0';  

        $revenue->update($request->all());

        $request['payment_id'] = $payment->id;
        $request['revenue_id'] = $revenue->id;
        $transfer->update($request->all());        

        $message = trans('messages.success.updated', ['type' => trans_choice('general.transfers', 1)]);

        $subject = trans('messages.success.added', ['type' => trans_choice('general.transfers', 1)]);

        Mail::to(config('configurations.mailusername'))->send(new SendHtml(auth()->user()->email,$message,$subject));

        Session::flash('success',$message);

        return redirect('banking/transfers');
    }
}
