<?php

namespace App\Http\Controllers\Accounts\Banking;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Session;
use App\Models\Accounts\Banking\Account;
use App\Models\Accounts\Banking\Reconcile;
use App\Models\Accounts\Accounting\Charthistory;

class Reconciles extends Controller
{
    public function index(){

        $reconciliations = Reconcile::where('account_id', '!=', '')->get();

    	$accounts = Account::whereEnabled(1)->get()->pluck('name_number', 'id');

    	return view('accounts.banking.reconcile.index',compact('accounts','reconciliations'));
    }

      /**
     * Show the form for creating a new resource.
     *
     * @return Response
     */
    public function create()
    {
        $accounts = Account::whereEnabled(1)->get()->pluck('name_number', 'id');

        $account_id = request('account_id', setting('general.default_account'));

        $started_at = $this->formatDate(request('started_at', '0000-00-00'));
        $ended_at = $this->formatDate(request('ended_at', '0000-00-00'));

        $account = Account::find($account_id);

        $currency = 'USD';

        $account = Account::with(['chartofaccount'])->where('id','=',$account_id)->first();
          
         
        $accuount_chart_id =isset($account->chartofaccount->id)?$account->chartofaccount->id:'';

        $transactions = Charthistory::where('chartofaccount_id',$accuount_chart_id)->whereBetween('transaction_date',[$started_at, $ended_at])->onlytranscations()->get()->collect(['transaction_date','desc']);  
        $opening_balance = isset($account->opening_balance)?$account->opening_balance:0;
       

        return view('accounts.banking.reconcile.create', compact('accounts', 'account', 'currency', 'opening_balance', 'transactions'));
    }


    /**
     * Store a newly created resource in storage.
     *
     * @param  Request  $request
     *
     * @return Response
     */
    public function store(Request $request)
    {
        $reconcile = $request->get('reconcile');
        $transactions = $request->get('transactions');

        Reconcile::create([
            'company_id' => session('company_id'),
            'account_id' => $request->get('account_id'),
            'started_at' => $request->get('started_at'),
            'ended_at' => $request->get('ended_at'),
            'closing_balance' => $request->get('closing_balance'),
            'reconciled' => $reconcile ? 1 : 0,
        ]);

        if ($transactions) {
            foreach ($transactions as $key => $value) {
                $t = explode('_', $key);
                $m = '\\' . $t['1'];

                $transaction = Charthistory::find($t[0]);
                $transaction->reconciled = 1;
                $transaction->save();
            }
        }

        $message = trans('messages.success.added', ['type' => trans_choice('general.reconciliations', 1)]);

        Session::flash('success',$message);

        return redirect()->route('reconcile.index');
    }


    /**
     * Show the form for editing the specified resource.
     *
     * @param  Reconciliation  $reconciliation
     *
     * @return Response
     */
    public function edit(Reconcile $reconcile)
    {

        $account = $reconcile->account;

        $currency = $account->currency;

       // $accuount_chart_id = $account->chartofaccount;


        $accuount_chart_id =isset($account->chartofaccount->id)?$account->chartofaccount->id:'';

        $transactions = Charthistory::where('chartofaccount_id',$accuount_chart_id)->whereBetween('transaction_date',[$reconcile->started_at, $reconcile->ended_at])->onlytranscations()->get()->collect(['transaction_date','desc']);

        $opening_balance = $account->opening_balance;

        return view('accounts.banking.reconcile.edit', compact('reconcile', 'account', 'currency', 'opening_balance', 'transactions'));
    }

        /**
     * Update the specified resource in storage.
     *
     * @param  Reconciliation  $reconciliation
     * @param  Request  $request
     *
     * @return Response
     */
    public function update(Reconcile $reconcile_object, Request $request)
    {
        $reconcile = $request->get('reconcile');
        $transactions = $request->get('transactions');
 
        $reconcile_object->reconciled = $reconcile ? 1 : 0;
        $reconcile_object->save();

        if ($transactions) {
            foreach ($transactions as $key => $value) {
                $t = explode('_', $key);
               // $m = '\\' . $t['1'];

                $transaction = Charthistory::find($t[0]);
                $transaction->reconciled = 1;
                $transaction->save();
            }
        }

        $message = trans('messages.success.updated', ['type' => trans_choice('general.reconciliations', 1)]);

            Session::flash('success',$message);


        return redirect()->route('reconcile.index');
    }


    /**
     * Get the opening balance
     *
     * @param $account
     * @param $started_at
     *
     * @return string
     */
    public function getOpeningBalance($account, $started_at)
    {
        // Opening Balance
        $total = $account->opening_balance;

        // Sum invoices
        $invoice_payments = $account->invoice_payments()->whereDate('paid_at', '<', $started_at)->get();
        foreach ($invoice_payments as $item) {
            $total += $item->amount;
        }

        // Sum revenues
        $revenues = $account->revenues()->whereDate('paid_at', '<', $started_at)->get();
        foreach ($revenues as $item) {
            $total += $item->amount;
        }

        // Subtract bills
        $bill_payments = $account->bill_payments()->whereDate('paid_at', '<', $started_at)->get();
        foreach ($bill_payments as $item) {
            $total -= $item->amount;
        }

        // Subtract payments
        $payments = $account->payments()->whereDate('paid_at', '<', $started_at)->get();
        foreach ($payments as $item) {
            $total -= $item->amount;
        }

        return $total;
    }


    public function reconsole(Reconcilerequest $reconcile){

    	$reconcile['balance_as_of'] = date('Y-m-d',strtotime($reconcile->balance_as_of));
    	$reconcile['ending_date'] = date('Y-m-d',strtotime($reconcile->ending_date));
    	$reconcile['company_id'] = session('company_id');

    	$account = Account::with(['chartofaccount'])->where('id','=',$reconcile->bank_account_id)->first();
          if(!$account->chartofaccount){
            return redirect()->back();
          }

        //$reconcile = Reconcile::create($reconcile->all());

        $bank_balance_start_date = $account->balance_as_of;

    	$dates = array( '0' => 'Since 90 Days Ago', '1' => 'Since 60 Days Ago' , '2' => 'Since 30 Days Ago' );

        $date = new \DateTime();
        $date->modify('-3 Months');
        $formatted_date = $date->format('Y-m-d H:i:s');
        

       $chartofaccounts = Charthistory::with(['accounttype','detailtype'])->where('chartofaccount_id',$account->chartofaccount->id)->whereDate('created_at','<',$bank_balance_start_date)->orwhereDate('created_at' , '>' , $formatted_date)->collect(['created_at','desc']);

    	return view('accounts.banking.reconcile.reconcile',compact('reconcile','chartofaccounts','formatted_date','dates','account'));
    }

      public function calculate()
    {
        $currency_code = request('currency_code');
        $closing_balance = request('closing_balance');

        $json = new \stdClass();

        $cleared_amount = $difference = $income_total = $expense_total = 0;

        if ($transactions = request('transactions')) {
            $opening_balance = request('opening_balance');

            foreach ($transactions as $key => $value) {
                $model = explode('_', $key);

                if (($model[1] == 'add')) {
                    $income_total += $value;
                } else {
                    $expense_total += $value;
                }
            }

            $cleared_amount = $opening_balance + ($income_total - $expense_total);
        }

        $difference = $closing_balance - $cleared_amount;

        $json->closing_balance = money($closing_balance, $currency_code, true)->format();
        $json->cleared_amount = money($cleared_amount, $currency_code, true)->format();
        $json->difference = money($difference, $currency_code, true)->format();
        $json->income_total = money($income_total,$currency_code,true)->format();
        $json->expense_total = money($expense_total,$currency_code,true)->format();
        $json->difference_raw = (int) $difference;

        return response()->json($json);
    }
}
