<?php

namespace App\Http\Controllers\Accounts\Banking;

use App\Traits\Uploads;
use App\Utilities\Modules;
use App\Classes\DepositType;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use App\Models\Accounts\Charthistory;
use App\Models\Accounts\Expense\Vendor;
use App\Models\Accounts\Banking\Account;
use App\Models\Accounts\Banking\Deposit;
use App\Models\Accounts\Income\Customer;
use App\Models\Accounts\CharthistoryParent;
use App\Models\Accounts\Banking\DepositItem;
use App\Models\Accounts\Accounting\Chartofaccounts;

class DepositController extends Controller
{
    use Uploads;
    public $personname = [];

    public function index()
    {
        $deposites = Deposit::with(['account'])->orderBy('created_at','desc')->get()->collect(); 
        
        return view('accounts.banking.deposit.index',compact('deposites'));
    }

    public function create()
    {
        $accounts = Account::all()->collect()->pluck('name_number','id')->all();
        
        $this->addRecevedFrom(Customer::select(DB::raw('CONCAT(id,"-",1) as idconcate'),'name')->get(), 'Customer');
        $this->addRecevedFrom(Vendor::select(DB::raw('CONCAT(id,"-",2) as idconcate'), 'name')->get(), 'Vendor');
        
        $personname = $this->getPersonname();     
        
        $payment_methods = Modules::getPaymentMethods();

       return view('accounts.banking.deposit.create',compact('accounts','personname','payment_methods'));
    }

    protected function getPersonname()
    {        
        $personname = collect($this->personname);
       
        return $personname;
    }

    protected function addRecevedFrom($items,$type)
    {   
        foreach ($items as $item) {
            $data = [ 
                'id' => $item->idconcate,
                'name' => $item->name,
                'type' => $type
            ];

            $this->personname[] = (object) $data;
        }
    }

    public function show(Deposit $deposit)
    {      
        $accounts = Account::all()->pluck('name_number','id')->all();
        
        return view('accounts.banking.deposit.show',compact('deposit','accounts'));
    }

    public function totaldeposite()
    {
        $deposite = request('deposite');
        $currency_code = request('currency_code');
        $json = new \stdClass;
        $total = 0;

        foreach ($deposite as $key => $item) {
            $price = (double) $item['price'];

            $total  += $price;

            $items[$key] = money($price, $currency_code, true)->format();
        }
        $json->items = $items;
        $json->total = $total;
        $grand_total = $total ;
        $json->grand_total = money($grand_total, $currency_code, true)->format();

        return response()->json($json);
    }

    public function store(Request $request)
    {
        
        $date = $this->date_format_change_unique($request->paid_at);
        $request['paid_at'] = date('Y-m-d',strtotime($date[0]));
        $request['company_id'] = 1;
        $request['price']   = isset($request->totalprice)?$request->totalprice:0;
     
        $deposite_save =  Deposit::create($request->all());

        // Upload attachment
        if ($request->file('attachment')) {
            $media = $this->getMedia($request->file('attachment'), 'deposit');
            $deposite_save->attachMedia($media, 'attachment');
        }

        foreach ($request->deposite as $key => $value) {
            $value['company_id'] = 1;
            $value['deposit_id'] = $deposite_save->id;
            if($value['person_id']){
              if(explode('-',$value['person_id'])[1] == 1){
                  $value['person_type']  = 'customer';
              }else{
                  $value['person_type']  = 'vendor';
              }
            }
                
            DepositItem::create($value);
            
            $chart_object = Chartofaccounts::find($value['chart_id']);
            $chart_history = new Charthistory;
            $chart_history->company_id = 1;
            $chart_history->transaction_id = $deposite_save->id;
            $chart_history->transaction_type = 'Deposite';
            $chart_history->currency_code = 'USD';
            $chart_history->chartofaccount_id = $chart_object->id;
            $chart_history->account_type_id = $chart_object->account_type_id;
            $chart_history->detail_type = $chart_object->detail_type;
            $chart_history->amount = $value['price'];
            $chart_history->description = $value['memo'];
            $chart_history->amount_type = DepositType::find($chart_object->id,'credit');
            $chart_history->number = $value['memo'];
            $chart_history->transaction_date = date('Y-m-d',strtotime($date[0]));
            $chart_history->save();

            $chartparents = app('App\Http\Controllers\Accounts\Accounting\Accounting')->parent_chartaccount_id($value['chart_id']);
 
            CharthistoryParent::charthistoryparentsave($chart_history->id,$chartparents->original['parent_id_string'],$value['chart_id']);

        }

        $chart_object = Chartofaccounts::where('bank_id',$request->account_id)->first();

        if($chart_object){
            $chart_history = new Charthistory;
            $chart_history->company_id = 1;
            $chart_history->transaction_id = $deposite_save->id;
            $chart_history->transaction_type = 'Deposite';
            $chart_history->currency_code = 'USD';
            $chart_history->chartofaccount_id = $chart_object->id;
            $chart_history->account_type_id = $chart_object->account_type_id;
            $chart_history->detail_type = $chart_object->detail_type;
            $chart_history->amount = $request->totalprice;
            $chart_history->description = $request->notes;
            $chart_history->amount_type = DepositType::find($chart_object->id,'debit');
            $chart_history->number = $request->memo;
            $chart_history->transaction_date = date('Y-m-d',strtotime($date[0]));
            $chart_history->save();

            $chartparents = app('App\Http\Controllers\Accounts\Accounting\Accounting')->parent_chartaccount_id($chart_object->id);
 
            CharthistoryParent::charthistoryparentsave($chart_history->id,$chartparents->original['parent_id_string'],$chart_object->id);
        }
        return redirect('banking/deposit');
    }

    public function edit(Deposit $deposit)
    {
        $accounts = Account::get()->collect()->pluck('name_number','id')->all();

        $this->addRecevedFrom(Customer::select(\DB::raw('CONCAT(id,"-",1) as idconcate'),'name')->get(), 'Customer');
        $this->addRecevedFrom(Vendor::select(\DB::raw('CONCAT(id,"-",2) as idconcate'),'name')->get(), 'Vendor');

        $personname = $this->getPersonname();
        $payment_methods = Modules::getPaymentMethods();

       return view('accounts.banking.deposit.edit',compact('accounts','personname','payment_methods','deposit'));
    }

    public function update(Deposit $deposit, Request $request)
    {
        $date = $this->date_format_change_unique($request->paid_at);
        $deposit['paid_at'] = date('Y-m-d',strtotime($date[0]));
        $deposit['company_id'] = 1;
        $deposit['price']   = isset($request->totalprice)?$request->totalprice:0;
        $deposit['memo']    = $request->memo;
        $deposit['notes']    = $request->notes;
        $deposit['account_id']    = $request->account_id;        
 
        Charthistory::where('transaction_id',$deposit->id)->where('transaction_type','Deposite')->delete();
        if($request->deposit){
            DepositItem::where('deposit_id',$deposit->id)->delete();
            foreach ($request->deposite as $key => $value) {
                $value['company_id'] = 1;
                $value['deposit_id'] = $deposit->id;
                 if($value['person_id']){
                    if(explode('-',$value['person_id'])[1] == 1){
                        $value['person_type']  = 'customer';
                    }else{
                        $value['person_type']  = 'vendor';
                    }
                 }else{
                        $value['person_type']  = null;
                 }
                DepositItem::create($value);
                $chart_object = Chartofaccounts::find($value['chart_id']);

                $chart_history = new Charthistory;
                $chart_history->company_id = 1;
                $chart_history->transaction_id = $deposit->id;
                $chart_history->transaction_type = 'Deposite';
                $chart_history->currency_code = 'USD';
                $chart_history->chartofaccount_id = $chart_object->id;
                $chart_history->account_type_id = $chart_object->account_type_id;
                $chart_history->detail_type = $chart_object->detail_type;
                $chart_history->amount = $value['price'];
                $chart_history->description = $value['memo'];
                $chart_history->amount_type = DepositType::find($chart_object->id,'credit');
                $chart_history->number = $value['memo'];
                $chart_history->transaction_date = date('Y-m-d',strtotime($date[0]));
                $chart_history->save();

                $chartparents = app('App\Http\Controllers\Accounts\Accounting\Accounting')->parent_chartaccount_id($value['chart_id']);
 
                CharthistoryParent::charthistoryparentsave($chart_history->id,$chartparents->original['parent_id_string'],$value['chart_id']);
            }
        }
        $chart_object = Chartofaccounts::where('bank_id',$request->account_id)->first();

        if($chart_object){
            $chart_history = new Charthistory;
            $chart_history->company_id = 1;
            $chart_history->transaction_id = $deposit->id;
            $chart_history->transaction_type = 'Deposite';
            $chart_history->currency_code = 'USD';
            $chart_history->chartofaccount_id = $chart_object->id;
            $chart_history->account_type_id = $chart_object->account_type_id;
            $chart_history->detail_type = $chart_object->detail_type;
            $chart_history->amount = isset($request->totalprice)?$request->totalprice:0;
            $chart_history->description = $request->notes;
            $chart_history->amount_type = DepositType::find($chart_object->id,'debit');
            $chart_history->number = $request->memo;
            $chart_history->transaction_date = date('Y-m-d',strtotime($date[0]));
            $chart_history->save();

            $chartparents = app('App\Http\Controllers\Accounts\Accounting\Accounting')->parent_chartaccount_id($chart_object->id);
 
            CharthistoryParent::charthistoryparentsave($chart_history->id,$chartparents->original['parent_id_string'],$chart_object->id);
        }

        // Upload attachment
        if ($request->file('attachment')) {
            $media = $this->getMedia($request->file('attachment'), 'deposit');
            $deposit->attachMedia($media, 'attachment');
        }
        $deposit->update();
        
        return redirect('banking/deposit/'. $deposit->id);
    }
}
