<?php

namespace App\Http\Controllers\Accounts;

use App\Mail\SendHtml;
use App\Classes\DepositType;
use Illuminate\Http\Request;
use Akaunting\Money\Currency;
use App\Models\Accounts\Banking\Account;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Mail;
use App\Models\Accounts\Charthistory;
use Illuminate\Support\Facades\Session;
use App\Models\Accounts\CharthistoryParent;
use App\Models\Accounts\Accounting\Chartofaccounts;

class AccountsController extends Controller
{
    public function index()
    {
        $accounts = Account::orderBy('created_at','desc')->paginate(100); 
        if(request('page')){
            return view('accounts.banking.accounts.ajaxrender', compact('accounts'));
        };

        return view('accounts.banking.accounts.index', compact('accounts'));
    }

    public function create()
    {
        return view('accounts.banking.accounts.create');
    }

    public function store(Request $request)
    {
        $date = $this->date_format_change_unique($request->balance_as_of);
        $request['balance_as_of'] =  date("Y-m-d", strtotime($date[0]));
        $request['company_id'] = 1;
        $request['enabled'] = isset($request->enabled)?$request->enabled:1;
        $account = Account::create($request->all());

        $request['account_type_id'] = 3;
        $request['description'] = $request->bank_address;
        $request['detail_type'] = 41;
        $request['bank_id'] = $account->id;

        $chartofaccounts = Chartofaccounts::create($request->input());
    
        $charthistory = new Charthistory();
        $charthistory->chartofaccount_id = $chartofaccounts->id;
        $charthistory->account_type_id   = $request->account_type_id;
        $charthistory->detail_type       = $request->detail_type;
        $charthistory->amount            = $request->opening_balance;
        $charthistory->transaction_type  = 'Opening Balance';
        $charthistory->company_id        = $request->company_id;
        $charthistory->currency_code     = 'USD';
        $charthistory->amount_type       = DepositType::find($chartofaccounts->id,'debit');
        $charthistory->transaction_date  = date("Y-m-d", strtotime($date[0]));
        $charthistory->transaction_id  = '001';
        $charthistory->save();

        $chartparents = app('App\Http\Controllers\Accounts\Accounting\Accounting')->parent_chartaccount_id($chartofaccounts->id);
 
        CharthistoryParent::charthistoryparentsave($charthistory->id,$chartparents->original['parent_id_string'],$chartofaccounts->id);

        // Set default account
        if ($request['default_account']) {
            setting()->set('general.default_account', $account->id);
            setting()->save();
        }

        $message = trans('messages.success.added', ['type' => trans_choice('general.accounts', 1)]);

        $subject =   trans('accounts.name') . ':' . $account->name . '</br>' . trans('accounts.number')  .':' . $account->number . '</br>' . trans('accounts.opening_balance') .':'. $account->opening_balance; 

        Mail::to(config('configurations.mailusername'))->send(new SendHtml(auth()->user()->email,$message,$subject));
        
        Session::flash('success', $message);
        return redirect('/banking/accounts');
    }

    public function edit(Account $account)
    {
        $account->default_account = ($account->id == setting('general.default_account')) ?: 0;

        return view('accounts.banking.accounts.edit', compact('account'));
    }

    public function update(Account $account, Request $request)
    {
        $date = $this->date_format_change_unique($request->balance_as_of);
        $request['balance_as_of'] =  date("Y-m-d", strtotime($date[0]));
        $request['enabled'] = isset($request->enabled)?$request->enabled:0;
        $account->update($request->all());

        $request['account_type_id'] = 3;
        $request['description'] = $request->bank_address;
        $request['detail_type'] = 41;
        $request['bank_id'] = $account->id;
        $chartofaccounts = Chartofaccounts::where('bank_id',$account->id)->first();
        $chartofaccounts->update($request->all()); 

        $charthistory = Charthistory::where('transaction_type','Opening Balance')->where('chartofaccount_id',$chartofaccounts->id)->first();
        $charthistory->account_type_id   = 3;
        $charthistory->detail_type       =  41;
        $charthistory->amount            = $request->opening_balance;
        $charthistory->transaction_type  = 'Opening Balance';
        $charthistory->company_id        = 1;
        $charthistory->currency_code     = 'USD';
        $charthistory->amount_type       = DepositType::find($chartofaccounts->id,'debit');
        $charthistory->transaction_date  = date("Y-m-d", strtotime($date[0]));
        $charthistory->update();
        // Set default account
        if ($request['default_account']) {
            setting()->set('general.default_account', $account->id);
            setting()->save();
        }

        $message = trans('messages.success.updated', ['type' => trans_choice('general.accounts', 1)]);

        $subject =   trans('accounts.name') . ':' . $account->name . '</br>' . trans('accounts.number')  .':' . $account->number . '</br>' . trans('accounts.opening_balance') .':'. $account->opening_balance; 

        Mail::to(config('configurations.mailusername'))->send(new SendHtml(auth()->user()->email,$message,$subject));

        Session::flash('success',$message);

        return redirect('banking/accounts');
    }

    // Change Status
    public function changeStatus(Request $request)
    {
        if($request->type == 1) {
            Account::whereId($request->account_id)->update(['enabled'=>0]);
            $sts = 'Account Disabled Successfully!.';
        }
        
        if($request->type == 0) {
            Account::whereId($request->account_id)->update(['enabled'=>1]);
            $sts = 'Account Enabled Successfully!.';
        }

        return back()->with('success', $sts);
    }

    // Get Account Balance BY Passing ID
    public function accountbalance($id)
    {
        $account_balance = Account::find($id)->balance;
        return money($account_balance);
    }

    public function show(Account $account)
    {  

        $accuount_chart_id =isset($account->chartofaccount->id)?$account->chartofaccount->id:'';


        $transactions = Charthistory::where('chartofaccount_id',$accuount_chart_id)->onlytranscations()->orderBy('created_at','desc')->get();
      
     return view('accounts.banking.accounts.show',compact('transactions','account'));
    }

    protected function addTransactions($items, $type, $category = null)
    {   
            foreach ($items as $item) {
                $data = [
                    'paid_at'           => $item->paid_at,
                    'account_name'      => $item->account->name,
                    'type'              => $type,
                    'description'       => $item->description,
                    'amount'            => $item->amount,
                    'currency_code'     => $item->currency_code,
                ];
                if (!is_null($category)) {
                    $data['category_name'] = $category;
                } else {
                    $data['category_name'] = isset($item->category->name)?$item->category->name:'';
                }

                $this->transactions[] = (object) $data;
            }
    }

    protected function getTransactions($request)
    {
        // Sort items
        if (isset($request['sort'])) {
            if ($request['order'] == 'asc') {
                $f = 'sortBy';
            } else {
                $f = 'sortByDesc';
            }
            $transactions = collect($this->transactions)->$f($request['sort']);
        } else {
            $transactions = collect($this->transactions)->sortByDesc('paid_at');
        }

        return $transactions;
    }

    public function destroy(Account $account)
    {
        $relationships = $this->countRelationships($account, [
            'bill_payments' => 'bills',
            'payments' => 'payments',
            'invoice_payments' => 'invoices',
            'revenues' => 'revenues',
        ]);

        if (empty($relationships)) {
            $account->delete();

            $message = trans('messages.success.deleted', ['type' => trans_choice('general.accounts', 1)]);

            \Session::flash('success',$message);
        } else {
            $message = trans('messages.warning.deleted', ['name' => $account->name, 'text' => implode(', ', $relationships)]);

            \Session::flash('warning',$message);
        }

        return redirect('banking/accounts');
    }

    public function beginingbalance($id){

        $account   =     Account::find($id);
        $opening_balance = $account->opening_balance;
        $balance_as_of = $account->balance_as_of;

       return  response()->json(['opening_balance'=> money($opening_balance) , 'balance_as_of' => $balance_as_of]);
    }
}
