<?php

namespace App\Http\Controllers\Accounts\Accounts\Expenses;

use Illuminate\Support\Str;
use App\Classes\DepositType;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Accounts\Charthistory;
use App\Models\Accounts\Expense\Bill;
use App\Models\Accounts\Expense\Vendor;
use App\Http\Requests\Expense\DebitRequest;
use App\Models\Accounts\CharthistoryParent;
use App\Models\Accounts\Expense\BillHistory;
use App\Models\Accounts\Expense\BillPayment;
use App\Models\Accounts\Expense\DebitMemoItem;
use App\Models\Accounts\Expense\DebitMemoModel;
use App\Models\Accounts\Accounting\Chartofaccounts;

class DebitMemos extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $debitmemo = DebitMemoModel::all();

        return view('accounts.expenses.debitmemo.index',compact('debitmemo'));    
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $vendors = Vendor::whereEnabled(1)->pluck('name','id');


        return view('accounts.expenses.debitmemo.create',compact('vendors'));
    }

    

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(DebitRequest $debitrequest)
    {
        // dd($debitrequest->all());
        $date = $this->date_format_change_unique($debitrequest->debitmemo_at);
        $debitrequest['company_id']      = session('company_id');
        $debitrequest['debitmemo_at'] = date("Y-m-d", strtotime($date[0]));
        $paid_at  = date("Y-m-d", strtotime($date[0]));
        $vendor = Vendor::find($debitrequest->vendor_id);
        $debitrequest['vendor_id'] = $debitrequest->vendor_id;
        $debitrequest['vendor_name']  = $vendor->name;
        $debitrequest['vendor_email']  = $vendor->email;
        $debitrequest['vendor_address'] = $debitrequest->address;
        $debitrequest['status'] = 'closed';
        $debit_memo = DebitMemoModel::create($debitrequest->all());

        $sub_total = 0;

        $chart_history = [];
        $chart_history['company_id'] = session('company_id');
        $chart_history['transaction_id'] = $debit_memo->id;
        $chart_history['transaction_type'] = 'Debit Memo';
        $chart_history['currency_code'] = 'USD';
       
        $chart_history['name'] = $vendor->name;
        $chart_history['transaction_date'] = $paid_at;

        if ($debitrequest['item']) {
            foreach ($debitrequest['item'] as $item) {
                $chart_object = Chartofaccounts::find($item['chartid']);
                $debit_memo_item['chartid'] = $item['chartid'];
                $debit_memo_item['company_id'] = session('company_id');
                $debit_memo_item['name'] = Str::limit($chart_object->name, 180, '');
                $debit_memo_item['price'] = $item['price'];
                $debit_memo_item['debit_memo_id'] = $debit_memo->id;
                DebitMemoItem::create($debit_memo_item);

                //Set Chart History. 
                $chart_history['amount_type'] = DepositType::find($item['chartid'], 'credit');
                $chart_history['chartofaccount_id'] = $item['chartid'];
                $chart_history['account_type_id'] = $chart_object['account_type_id'];
                $chart_history['detail_type'] = $chart_object['detail_type'];
                $chart_history['amount'] = $item['price'];
                $chart_history['description'] = $debitrequest->notes;

                $chart_history_id = Charthistory::create($chart_history);

                $chartparents = app('App\Http\Controllers\Accounts\Accounting\Accounting')->parent_chartaccount_id($item['chartid']);
 
                CharthistoryParent::charthistoryparentsave($chart_history_id->id,$chartparents->original['parent_id_string'],$item['chartid']); 

                $sub_total += $debit_memo_item['price'];
            }
        }

        $amount = $sub_total;
        $debit_memo->total = $amount;
        $debit_memo->update();

        $chart =  Chartofaccounts::where('name','=','Accounts Payable')->first();
        $chart_history = [];
        $chart_history['company_id'] = session('company_id');
        $chart_history['transaction_id'] = $debit_memo->id;
        $chart_history['transaction_type'] = 'Debit Memo';
        $chart_history['currency_code'] = 'USD';
        $chart_history['amount_type'] = DepositType::find($chart->id,'debit');
        $chart_history['name'] = $vendor->name;
        $chart_history['chartofaccount_id'] = $chart->id;
        $chart_history['account_type_id'] = $chart->account_type_id;
        $chart_history['detail_type'] = $chart->detail_type;
        $chart_history['amount'] = $sub_total;
        $chart_history['description'] = 'Debit Memo';
        $chart_history['transaction_date'] = $paid_at;

        $chart_history_id = Charthistory::create($chart_history);


        $chartparents = app('App\Http\Controllers\Accounts\Accounting\Accounting')->parent_chartaccount_id($chart->id);

        CharthistoryParent::charthistoryparentsave($chart_history_id->id,$chartparents->original['parent_id_string'],$chart->id); 

        // Updating Bill Payments for bills
        if($debitrequest->bill) {
            foreach ($debitrequest->bill as $key => $value) {
                $value = (object)$value;
                $payment = new BillPayment;
                $payment->company_id = session('company_id');
                $payment->bill_id = $key;
                $payment->paid_at = date('Y-m-d', strtotime($debitrequest->debitmemo_at));
                $payment->amount = $value->bill_amount;
                $payment->currency_code = 'USD';
                $payment->currency_rate = 1;
                $payment->save();

                $billamount = Bill::whereId($key)->first()->amount;
                $billpaymentamount = BillPayment::whereBill_id($key)->sum('amount');

                $bill = Bill::find($key);
                if ($billamount == $billpaymentamount) {
                    $bill->bill_status_code = 'paid';
                } else {
                    $bill->bill_status_code = 'partial';
                }
                $bill->save();

                $history = new BillHistory;
                $history->company_id = session('company_id');
                $payment->bill_id = $key;
                $history->description = $value->bill_amount.' Debitmemo added';
                $history->status_code = $bill->bill_status_code;
                $history->save();
            }
        }

        return redirect()->back()->with('success', 'Debitmemo raised successfully!.');
    }


    public function getbills($id){
        $bills = Bill::with(['payments_total'])->where('amount', '!=', 0)->whereVendor_id($id)->where('bill_status_code', '!=', 'paid')->get();
        
        return view('accounts.expenses.debitmemo.bill_list', compact('bills'));
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show(DebitMemoModel $debitmemo)
    {
        // dd($debitmemo);
        return view('accounts.expenses.debitmemo.show',compact('debitmemo'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        return view('accounts.expenses.debitmemo.edit');
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        return view('accounts.expenses.debitmemo.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        return view('accounts.expenses.debitmemo.index');
    }
}
