<?php

namespace App\Http\Controllers\Accounts\Accounting;

use Illuminate\Http\Request;
use App\Utilities\ImportFile;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Session;
use App\Models\Accounts\Expense\BillItem;
use App\Models\Accounts\CharthistoryParent;
use App\Models\Accounts\Expense\ChequeItem;
use App\Models\Accounts\Income\InvoiceItem;
use App\Models\Accounts\Expense\BillAccount;
use App\Models\Accounts\Accounting\Accounttypes;
use App\Models\Accounts\Accounting\Charthistory;
use App\Models\Accounts\Accounting\Accountdetails;
use App\Models\Accounts\Accounting\Chartofaccounts;
use App\Models\Accounts\Banking\Account as BankAccount;
use App\Http\Requests\Accounts\Accounting as Chartrequest;

class AccountingController extends Controller
{
    public $transactions = [];
    private $chart_account = [];

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $elements = Chartofaccounts::with(['accounttype', 'detailtype', 'bank'])->orderBy('created_at','desc')->get()->toArray();

        $page = isset(request()->page)?request()->page:1;

        $chartofaccounts = $this->bulidAccounting($elements); 

        if(request('page')){
            return view('accounts.accounting.chartofaccounts.ajaxrender',compact('chartofaccounts'));
        };

        return view('accounts.accounting.chartofaccounts.index',compact('chartofaccounts'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
       $types = collect(Accounttypes::pluck('account_name','id'));  

       //$detailtype = collect(Accountdetails::pluck('detail_type','id'));
       $currencies = Currency::enabled()->pluck('name', 'code');
       

       $elements = Chartofaccounts::select('name','id','chart_parent_id')->get()->toArray();
    
       $subaccount = $this->bulidAccounting($elements);
       
 
     return view('accounts.accounting.chartofaccounts.create',compact('types','currencies','subaccount'));
    }


    public function bulidAccounting(array $elements, $parentId = NULL) 
    {
        $child = array();
    
        foreach ($elements as $element) {
            if ($element['chart_parent_id'] == $parentId) {

                $children = $this->bulidAccounting($elements, $element['id']);

                    if (!empty($children) > 0 ) {
                        $element['children'] = $children;
                    }

                $child[] = $element;
            }
        }

        return $child;
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Chartrequest $chartofaccounts)
    {       
        $chartofaccounts['balance_as_of']     = date('Y-m-d',strtotime($chartofaccounts->balance_as_of));
        $chartofaccounts['balance']     = isset($chartofaccounts->balance)?$chartofaccounts->balance:0;
        if(in_array($chartofaccounts->account_type_id,[3,7])){
            $account                    = new BankAccount();
            $account->company_id        = session('company_id');
            $account->name              = $chartofaccounts->name;
            $account->bank_name         = $chartofaccounts->name;
            $account->number            = $chartofaccounts->number;
            $account->opening_balance   = $chartofaccounts->balance;
            $account->currency_code     = $chartofaccounts->currency_code;
            $account->enabled           =$chartofaccounts->enabled;
            $account->balance_as_of     = date('Y-m-d',strtotime($chartofaccounts->balance_as_of));
            $account->save();

            $chartofaccount                 = new Chartofaccounts();
            $chartofaccount->company_id     = session('company_id');
            $chartofaccount->name           = $chartofaccounts->name;
            $chartofaccount->account_type_id= $chartofaccounts->account_type_id;
            $chartofaccount->detail_type    = $chartofaccounts->detail_type;
            $chartofaccount->description    = $chartofaccounts->description;
            $chartofaccount->currency_code  = $chartofaccounts->currency_code;
            $chartofaccount->opening_balance= $chartofaccounts->balance;
            $chartofaccount->enabled        = $chartofaccounts->enabled;
            $chartofaccount->balance_as_of     = date('Y-m-d',strtotime($chartofaccounts->balance_as_of));
            $chartofaccount->bank_id        = $account->id;
            $chartofaccount->save();
                
            $transaction_type = 'Opening Balance';
            $amount_type     = 'add';
            $this->chathistory_save($chartofaccount->id,$chartofaccounts->account_type_id,$chartofaccounts->detail_type,$chartofaccounts->balance,$transaction_type,$amount_type);
           
        }else{
            $chartofaccounts['company_id']      =  session('company_id');
            $chartofaccounts['opening_balance'] =  $chartofaccounts->balance;
            $chartofaccount_save =  Chartofaccounts::create($chartofaccounts->all());
            if(in_array($chartofaccounts->account_type_id ,[2,4,5,10,8,9,17])){ 
                $transaction_type = 'Opening Balance';
                $amount_type     = 'add';

                $this->chathistory_save($chartofaccount_save->id,$chartofaccount_save->account_type_id,$chartofaccount_save->detail_type,$chartofaccount_save->balance,$transaction_type,$amount_type);
            }
            if(in_array($chartofaccounts->account_type_id ,[2,4,5,10])){
                 $chart =  Chartofaccounts::where('name','=','Opening Balance Equity')->first();
                //dd($chart);
                $transaction_type = 'Opening Balance Equity';
                $amount_type = 'add';
                $this->chathistory_save($chart->id,$chart->account_type_id,$chart->detail_type,$chartofaccounts->balance,$transaction_type,$amount_type);
            }
        }

        $message = trans('messages.success.added', ['type' => trans_choice('general.chartsofaccount', 1)]);

        \Session::flash('success',$message);

        return redirect('accounting/chartofaccounts');
    }

    public function chartofaccounts_model_data(Chartrequest $chartofaccounts)
    {
        $chartofaccounts['balance_as_of']     = date('Y-m-d',strtotime($chartofaccounts->balance_as_of));
        $chartofaccounts['balance']     = isset($chartofaccounts->balance)?$chartofaccounts->balance:0;
        $chartofaccounts['currency_code'] = 'USD';
        if(in_array($chartofaccounts->account_type_id,[3,7])){
            $account                    = new BankAccount();
            $account->company_id        = session('company_id');
            $account->name              = $chartofaccounts->name;
            $account->bank_name         = $chartofaccounts->name;
            $account->number            = $chartofaccounts->number;
            $account->opening_balance   = $chartofaccounts->balance;
            $account->currency_code     = $chartofaccounts->currency_code;
            $account->enabled           =$chartofaccounts->enabled;
            $account->balance_as_of     = date('Y-m-d',strtotime($chartofaccounts->balance_as_of));
            $account->save();

            $chartofaccount                 = new Chartofaccounts();
            $chartofaccount->company_id     = session('company_id');
            $chartofaccount->name           = $chartofaccounts->name;
            $chartofaccount->account_type_id= $chartofaccounts->account_type_id;
            $chartofaccount->detail_type    = $chartofaccounts->detail_type;
            $chartofaccount->description    = $chartofaccounts->description;
            $chartofaccount->currency_code  = $chartofaccounts->currency_code;
            $chartofaccount->opening_balance= $chartofaccounts->balance;
            $chartofaccount->enabled        = $chartofaccounts->enabled;
            $chartofaccount->balance_as_of     = date('Y-m-d',strtotime($chartofaccounts->balance_as_of));
            $chartofaccount->bank_id        = $account->id;
            $chartofaccount->save();
                
            $transaction_type = 'Opening Balance';
            $amount_type     = 'add';
            $this->chathistory_save($chartofaccount->id,$chartofaccounts->account_type_id,$chartofaccounts->detail_type,$chartofaccounts->balance,$transaction_type,$amount_type);
           
        }else{
            $chartofaccounts['company_id']      =  session('company_id');
            $chartofaccounts['opening_balance'] =  $chartofaccounts->balance;
            $chartofaccount  =  Chartofaccounts::create($chartofaccounts->all());
            if(in_array($chartofaccounts->account_type_id ,[2,4,5,10,8,9,17])){ 
                $transaction_type = 'Opening Balance';
                $amount_type     = 'add';

                $this->chathistory_save($chartofaccount->id,$chartofaccount->account_type_id,$chartofaccount->detail_type,$chartofaccount->balance,$transaction_type,$amount_type);
            }
            if(in_array($chartofaccounts->account_type_id ,[2,4,5,10])){
                 $chart =  Chartofaccounts::where('name','=','Opening Balance Equity')->first();
                //dd($chart);
                $transaction_type = 'Opening Balance Equity';
                $amount_type = 'add';
                $this->chathistory_save($chart->id,$chart->account_type_id,$chart->detail_type,$chartofaccounts->balance,$transaction_type,$amount_type);
            }
        }

        $chartofaccount['present_value_of_dropdown'] = $chartofaccounts->present_value_of_dropdown;
        $chartofaccount['account_type_name'] = Accounttypes::find($chartofaccounts->account_type_id)->account_name;
 
        return $chartofaccount;
    }

    public function parent_chartaccount_id($id)
    {
        $chart_account = Chartofaccounts::with(['parentRecrusive' => function($query) {
                        $query->select(['id','name','chart_parent_id']); }
                    ])->select('id','name','chart_parent_id')->find($id);
        $name = '';
        $parent_id_string ='';
        if(!is_null($chart_account->parentRecrusive)) {
            if($chart_account->parentRecrusive->parent_re){
                $name_p = $this->bulidNameAccount($chart_account->parentRecrusive->parent_re);
                
                foreach (array_reverse($name_p) as $key => $value) {
                   $name .= $value['name'] . ':'; 
                   $parent_id_string .= $value['chart_parent_id'] . ',';
                }
            }
          
            $parent_id_string .= $chart_account->parentRecrusive->id . ',';
            $name .= $chart_account->parentRecrusive->name . ':';
            $parent_id = explode(',', $parent_id_string);
            $parent_re = $parent_id[count($parent_id)-2];
        }

        $name .= $chart_account->name ;
        $parent_one_id = isset($parent_id[0]) ?  $parent_id[0] : '0';
        $parent_id     = isset($parent_re) ? $parent_re : $id ;

        return  response()->json(['full_name'=> $name ,'parent_id' => $parent_id , 'parent_one_id' => $parent_one_id,'parent_id_string'=>$parent_id_string]);

    }

    function bulidNameAccount($elements) {
        if($elements){
            $arrayName = array('name' =>  $elements->name,'chart_parent_id' => $elements->id );
            array_push($this->chart_account,$arrayName);
            if($elements->parent_re){
                $children = $this->bulidNameAccount($elements->parent_re);
            }
        }
        return $this->chart_account;
    }

    public function chathistory_save($chart_id, $account_type_id, $detail_type, $balance, $transaction_type, $amount_type)
    {
        $charthistory = new Charthistory();
        $charthistory->chartofaccount_id = $chart_id;
        $charthistory->account_type_id   = $account_type_id;
        // $charthistory->detail_type       = $detail_type;
        $charthistory->amount            = $balance;
        $charthistory->transaction_type  = $transaction_type;
        $charthistory->company_id        = session('company_id');
        $charthistory->currency_code     = 'USD';
        $charthistory->amount_type       = $amount_type;
        $charthistory->save();
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show(Request $request, $id)
    {
       $dates = array( '0' => 'Since 90 Days Ago', '1' => 'Since 60 Days Ago' , '2' => 'Since 30 Days Ago' );

        $date = new \DateTime();
        $date->modify('-3 Months');
        $formatted_date = $date->format('Y-m-d H:i:s');
        
        $chart   = Chartofaccounts::find($id);  

        if($request->dateRange) {
            $dr = explode('-', $request->dateRange);
            $start = date('Y-m-d', strtotime($dr[0]));
            $end = date('Y-m-d', strtotime($dr[1]));

            $charthistory = CharthistoryParent::with(['chart_history' => function($query) use($start, $end) {
                $query->orderBy('transaction_date','asc');
                $query->whereBetween('transaction_date', [$start, $end]);
            }])->where('chart_id',$id)->get(); 
        } else {
            $charthistory = CharthistoryParent::with(['chart_history' => function($query) {
                $query->orderBy('transaction_date','asc');
            }])->where('chart_id',$id)->get(); 
        }

        if($request->ajax()) {
            return view('accounts.accounting.chartofaccounts.receivable-table',compact('charthistory','formatted_date','dates','id','chart'));
        }
        
        return view('accounts.accounting.chartofaccounts.runreport',compact('charthistory','formatted_date','dates','id','chart'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {    
       $chartofaccounts  = Chartofaccounts::with(['bank'])->find($id);      

       $types = collect(Accounttypes::pluck('account_name','id'));

        // $detailtype = collect(Accountdetails::pluck('detail_type','id'));

        $elements = Chartofaccounts::select('name','id','chart_parent_id')->get()->toArray();
    
       $subaccount = $this->bulidAccounting($elements);
       
       return view('accounts.accounting.chartofaccounts.edit',compact('chartofaccounts','types','subaccount'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update( Request $request, $id)
    {     
        $request['balance_as_of'] = date('Y-m-d',strtotime($request->balance_as_of));
         
        $chartofaccounts = Chartofaccounts::find($id);
        if($request->account_type_id == 3){
            if(!empty($chartofaccounts->bank_id)){
                $account                    = BankAccount::find($chartofaccounts->bank_id);
                $account->company_id        = session('company_id');
                $account->name              = $request->name;
                $account->bank_name         = $request->name;
                $account->number            = $request->number;
                $account->opening_balance   = $request->balance;
                $account->currency_code     = $request->currency_code;
                $account->enabled           = $request->enabled;
                $account->balance_as_of     = $request->balance_as_of;
                $account->update();
                //dd($account);

                $chartofaccounts->company_id     = session('company_id');
                $chartofaccounts->name           = $request->name;
                $chartofaccounts->account_type_id= $request->account_type_id;
                // $chartofaccounts->detail_type    = $request->detail_type;
                $chartofaccounts->description    = $request->description;
                $chartofaccounts->currency_code  = $request->currency_code;
                $chartofaccounts->opening_balance= $request->balance;
                $chartofaccounts->enabled        = $request->enabled;
                $chartofaccounts->bank_id        = $account->id;
                $chartofaccounts->balance_as_of     = $account->balance_as_of;
                $chartofaccounts->update();
            }else{
                $account                    = new BankAccount();
                $account->company_id        = session('company_id');
                $account->name              = $request->name;
                $account->bank_name         = $request->name;
                $account->number            = $request->number;
                $account->opening_balance   = $request->balance;
                $account->currency_code     = $request->currency_code;
                $account->enabled           = $request->enabled;
                $account->balance_as_of     = $request->balance_as_of;
                $account->save();

                
                $chartofaccounts->company_id     = session('company_id');
                $chartofaccounts->name           = $request->name;
                $chartofaccounts->account_type_id= $request->account_type_id;
                // $chartofaccounts->detail_type    = $request->detail_type;
                $chartofaccounts->description    = $request->description;
                $chartofaccounts->currency_code  = $request->currency_code;
                $chartofaccounts->opening_balance= $request->balance;
                $chartofaccounts->enabled        = $request->enabled;
                $chartofaccounts->bank_id        = $account->id;
                $chartofaccounts->update();
            }
        }else{
            $chartofaccounts['company_id'] =  session('company_id');
            if(!empty($chartofaccounts->bank_id)){
               /*  $account   = BankAccount::find($chartofaccounts->bank_id);
                 $account->delete();*/
                $chartofaccounts->name            = $request->name;
                $chartofaccounts->description     = $request->description;
                $chartofaccounts->currency_code   = $request->currency_code;
                $chartofaccounts->enabled         = $request->enabled;
                $chartofaccounts->bank_id         = null;
                $chartofaccounts->opening_balance = null;
                $chartofaccounts->account_type_id= $request->account_type_id;
                // $chartofaccounts->detail_type    = $request->detail_type;
                $chartofaccounts->update();
            }else{

                $chartofaccounts->update($request->all());
            }
        }

        $message = trans('messages.success.updated', ['type' => trans_choice('general.chartsofaccount', 1)]);

        \Session::flash('success',$message);

        return redirect('accounting/chartofaccounts');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }

	public function detailtype($id)
    {
		$item =	Accountdetails::where('account_type_id',$id)->select('detail_type as name','id')->get();

            $data = '';
            foreach($item as $items){
                $data  .=  '<option value="'.$items->id.'">'.$items->name.'</option>';
            }
        echo $data;   
	}

    public function runreport($id)
    {
        $accounttypes = Accounttypes::select('account_name', 'id')->find($id);
 
        $this->addTransactions(BillAccount::collect('created_at')->where('account_type_id',$id),trans_choice('general.bills', 1));
          
        $this->addTransactions(BillItem::collect('created_at')->where('chartid',$id),trans_choice('general.bills',1));

        $this->addTransactions(ChequeItem::collect('created_at')->where('chartid',$id),trans_choice('general.cheques',1));

        $this->addTransactions(InvoiceItem::where('chartid',$id)->get(),trans_choice('general.invoices',1));

        $transactions = $this->getTransactions();

      return view('accounts.accounting.chartofaccounts.runreport',compact('transactions'));
    }

     public function quickreportpdf($id)
     {      
        $dates = array( '0' => 'Since 90 Days Ago', '1' => 'Since 60 Days Ago' , '2' => 'Since 30 Days Ago' );
        $date = new \DateTime();
        $date->modify('-3 Months');
        $formatted_date = $date->format('Y-m-d H:i:s');
       
        $chartofaccounts = Charthistory::with(['accounttype','detailtype'])->where('chartofaccount_id',$id)->where('created_at' , '>' , $formatted_date)->get();

        $html = \view('accounts.accounting.chartofaccounts.pdfreport', compact('chartofaccounts','dates','id'))->render();

        $pdf = \App::make('dompdf.wrapper');
        $pdf->loadHTML($html);

        $file = public_path('app/report_'.time().'.pdf');

        $file_name = '/app/report_'.time().'.pdf';
        
        // Save the PDF file into temp folder
        $pdf->save($file);
        echo $file_name;
    }
    
    public function quickreportpdfdownload($id)
    {
        $dates = array( '0' => 'Since 90 Days Ago', '1' => 'Since 60 Days Ago' , '2' => 'Since 30 Days Ago' );
        $date = new \DateTime();
        $date->modify('-3 Months');
        $formatted_date = $date->format('Y-m-d H:i:s');
       
        $chartofaccounts = Charthistory::with(['accounttype','detailtype'])->where('chartofaccount_id',$id)->where('created_at' , '>' , $formatted_date)->get();

        $html = \view('accounts.accounting.chartofaccounts.pdfreport', compact('chartofaccounts','dates','id'))->render();

        $pdf = \App::make('dompdf.wrapper');
        $pdf->loadHTML($html);

        //$file = public_path('app/report_'.time().'.pdf');

        $file_name = '/app/report_'.time().'.pdf';
        
        // Save the PDF file into temp folder
         return $pdf->download($file_name);
    }

    public function quickreportemail($id){
        
        $dates = array( '0' => 'Since 90 Days Ago', '1' => 'Since 60 Days Ago' , '2' => 'Since 30 Days Ago' );
        $date = new \DateTime();
        $date->modify('-3 Months');
        $formatted_date = $date->format('Y-m-d H:i:s');
        $chartofaccounts = Charthistory::with(['accounttype','detailtype'])->where('chartofaccount_id',$id)->where('created_at' , '>' , $formatted_date)->get();
        $chartofaccount= $chartofaccounts->first();
       $html = view('accounts.accounting.chartofaccounts.pdfreport',compact('chartofaccounts','dates','id','chartofaccount'))->render();

        $pdf = \App::make('dompdf.wrapper');
        $pdf->loadHTML($html);
        $file_name = 'app/report_'.time().'.pdf';
        $pdf->save($file_name);
        $data = array(
                    'to'        => $chartofaccount->to,
                    'cc'        => $chartofaccount->cc,
                    'subject'  =>$chartofaccount->subject,
                    'message'   =>$chartofaccount->message,
                    );
        \Mail::send('accounts.email.sampleemail', compact('data') , function ($message) use ($data, $file_name) {

            $message->from('bhavaniudayasri@gmail.com');
            $message->to($data['to'])
                    ->subject($data['subject'])
                    ->cc($data['cc'])
                    ->attach($file_name, [
                                'as' => 'quickreport.pdf', 
                                'mime' => 'application/pdf'
                            ]);
            $message->getSwiftMessage();
        });
           
         $message = trans('messages.success.added', ['type' => trans('invoices.messages.email_sent')]);

        return response()->json([
            'success' => true,
            'error' => false,
            'message' => $message,
        ]);

    }

    protected function addTransactions($items, $type, $category = null)
    {   
        foreach ($items as $item) {
            $data = [
                'date'              => $item->created_at,
                'price'             => $item->price,
                'name'              => $item->name,
                'total'             => $item->total,
                'description'       => $item->description,
                'type'              => $type,
            ];

            if (!is_null($category)) {
                $data['category_name'] = $category;
            } else {
                $data['category_name'] = 'Danda';
            }
            $this->transactions[] = (object) $data;
        }
    }

    protected function getTransactions()
    {        
        $transactions = collect($this->transactions);
       
        return $transactions;
    }

    public function import(ImportFile $import)
    {
        $rows = $import->all();

        foreach ($rows as $row) {
            $data = $row->toArray();

            $chart_name =  explode(':',$data['account']);
            if(count($chart_name) > 1){
                $name = $chart_name[count($chart_name)-1];
                $parent_id = Chartofaccounts::where('name' , 'like', '%'. $chart_name[count($chart_name)-2])->first()->id;
            }else{
                $name = $chart_name[0]; 
                $parent_id = ''; 
            }

           $accounttype = Accounttypes::where('account_name','like', '%'.$data['type'] . '%')->first();
            if(!$accounttype){
               $accounttype =  Accounttypes::create([
                'account_name' => $data['type'],
                'company_id' => session('company_id')
                ]);
            }

            $accountdetail = Accountdetails::where('account_type_id','=',$accounttype->id)->where('detail_type','like','%' . $data['description']. '%')->first();

            if(!$accountdetail){
                $accountdetail = Accountdetails::create([
                    'detail_type' => $data['description'],
                    'account_type_id' => $accounttype->id
                ]);
            }
            $opening_balance  = str_replace(",", '',$data['balance_total']);

            if($accounttype->id=='3'){
                $account                    = new BankAccount();
                $account->company_id        = session('company_id');
                $account->name              = explode('-',$data['account'])[0];
                $account->bank_name         = explode('-',$data['account'])[0];
                $account->number            = explode('-',$data['account'])[1];
                $account->opening_balance   =  $opening_balance;
                $account->currency_code     = 'USD';
                $account->enabled           = '1';
                $account->balance_as_of     = \Date::today();
                $account->save();

                $chartofaccount                 = new Chartofaccounts();
                $chartofaccount->company_id     = session('company_id');
                $chartofaccount->name           = explode('-',$data['account'])[0];
                $chartofaccount->account_type_id= $accounttype->id;
                $chartofaccount->detail_type    = $accountdetail->id;
                $chartofaccount->description    = $data['description'];
                $chartofaccount->currency_code  = 'USD';
                $chartofaccount->opening_balance=  $opening_balance;
                $chartofaccount->enabled        = '1';
                $chartofaccount->balance_as_of     = \Date::today();
                $chartofaccount->bank_id        = $account->id;
                $chartofaccount->chart_parent_id = $parent_id;
                $chartofaccount->save();
            }else{
                   
                $chartofaccount                 = new Chartofaccounts();
                $chartofaccount->company_id     = session('company_id');
                $chartofaccount->name           = $name;
                $chartofaccount->account_type_id= $accounttype->id;
                $chartofaccount->detail_type    = $accountdetail->id;
                $chartofaccount->description    = $data['description'];
                $chartofaccount->currency_code  = 'USD';
                $chartofaccount->opening_balance=  $opening_balance;
                $chartofaccount->enabled        = '1';
                $chartofaccount->chart_parent_id = $parent_id;
                $chartofaccount->save();
            }
        }

        //print_r($chartofaccount);die;
        $message = trans('messages.success.imported', ['type' => trans_choice('general.chartsofaccount', 2)]);

        Session::flash('success',$message);

       return redirect('accounting/chartofaccounts');
    }


        public function paginate($items, $perPage = 25, $page = null, $options = [])
    {
        $page = $page ?: (Paginator::resolveCurrentPage() ?: 1);

        $items = $items instanceof Collection ? $items : Collection::make($items);

        return new LengthAwarePaginator($items->forPage($page, $perPage), $items->count(), $perPage, $page, $options);
    }
}
